#!/bin/bash
SCRIPT_PATH=$(dirname $(readlink -f ${BASH_SOURCE[0]}))
DISK_LSI_FW_DIR="$SCRIPT_PATH/../../../firmware/lsi/"
LSI_NEW_TOOL_PATH="$SCRIPT_PATH/../../tools/lsi/"
LSI_OLD_TOOL_PATH="$SCRIPT_PATH/../../tools/broadcom/storcli-linux"
COMMON_PATH="$SCRIPT_PATH/../cmn/common.sh"
PATHCFG_PATH="$SCRIPT_PATH/../../pathcfg.sh"
source $COMMON_PATH
source $PATHCFG_PATH

function LsiListHardDiskDrive()
{
    local ctrlModel=$1
    local disk_info=$2
    LSI_TOOL=$3
    local newVerion=$(echo ${disk_info}|awk -F, '{print $1}')
    local historicalVer=$(echo ${disk_info} | awk -F, '{print $5}')

    if [ "${historicalVer}" != "N/A" ];then
        diskInfo="${ctrlModel}, ${historicalVer}, lsi"
    else
        diskInfo="${ctrlModel}, lsi"
    fi

    if [ ! -f lsi_disk.list ];then
        echo "scaning harddisk in server ......"
    fi

    ${LSI_TOOL} show | grep -E "AVAGOMegaRAIDSAS|MegaRAID|SAS|AVAGOJBOD" > lsi_info.txt
    cat lsi_info.txt | while read line
    do
        local flag=$(echo $line | grep -Ec "AVAGOMegaRAIDSAS|MegaRAID|SAS|AVAGOJBOD")
        if [ $flag -ne 0 ];then
            local lsi_cardid=$(echo $line |sed -e 's/^[ \t]*//g'|awk '{print $1}')
            ${LSI_TOOL} /c$lsi_cardid /eall /sall show |grep "${ctrlModel}"> lsi_disk_info.txt
            cat lsi_disk_info.txt |while read line
            do
                local eid=$(echo $line |awk '{print $1}'| awk -F: '{print $1}')
                local slotid=$(echo $line |awk '{print $1}'| awk -F: '{print $2}')
                local firmware_version=$(${LSI_TOOL} /c$lsi_cardid /e$eid /s$slotid show all |grep -i "Firmware Revision"|awk '{print $4}')
                local sn=$(${LSI_TOOL} /c$lsi_cardid /e$eid /s$slotid show all |grep "SN" | awk '{print $3}')
                if [ "x$firmware_version" = "x$newVerion" ];then
                    printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s \n" "harddisk" "--"  ${ctrlModel} "--" ${sn} ${firmware_version} "--" >> lsi_disk_tmp.txt
                elif [ "${historicalVer}" = "N/A" ] || [[ "x${firmware_version}" =~ "x${historicalVer}" ]];then
                    echo "need update" >> ${NEED_UPDATE_FLAG}
                    printf "\e[31m%-10s %-10s %-20s %-10s %-16s %-8s %-3s \e[0m\n" "harddisk" "--" ${ctrlModel} "--" ${sn} ${firmware_version} "--" >> lsi_disk_tmp.txt
                fi
            done
            rm -f lsi_disk_info.txt
        fi
    done
    rm -f lsi_info.txt
    if [ ! -f "lsi_disk_tmp.txt" ];then
        echo "no harddisk " >> lsi_disk_tmp.txt
    fi
    local TotalNum=$(cat lsi_disk_tmp.txt| grep "$ctrlModel"|wc -l)
    local ModelNum=0
    if [ -f lsi_disk.list ] ;then
        ModelNum=$(cat lsi_disk.list| grep "$diskInfo"|wc -l)
    fi
    if [ ${ModelNum} -eq 0 ];then
        echo -e "====================Harddisk model(${diskInfo}) info===================== " >> lsi_disk.list

        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >> lsi_disk.list
        printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s\n"   Device  Verdor  Model FwType SerialNum  FwVer Slot >> lsi_disk.list
        cat lsi_disk_tmp.txt | grep "$ctrlModel" >> lsi_disk.list
    fi
    rm -f lsi_disk_tmp.txt
}

function updateDiskLsiFwCheck()
{
    # "lsi_harddisk_result.tmp" "${need_update}" "${ctrlModel}" "${newVersion}" "${updatetime}" "${cardid}" "${diskInfo}"
    resultFile=$1
    need_update=$2
    ctrlModel=$3
    newVersion=$4
    updatetime=$5
    cardid=$6
    local diskInfo=$7

    fwSucced=$(cat $resultFile | grep "update OK" | wc -l)
    fwfailed=$(cat $resultFile | grep "update failed" | wc -l)

    if [ $fwSucced -eq $need_update ];then
        greenFont "total harddisk ($diskInfo) need update num:$need_update,fw succeed num: $fwSucced, fw fwfailed num: ${fwfailed}, in lsi controller${cardid}" | tee -a lsi_update_harddisk.result
        updateResult $diskInfo "all" "default" "success" "--" $newVersion $updatetime "in lsi controller${cardid}"
    else
        redFont "total harddisk ($diskInfo) need update num:$need_update,fw succeed num: $fwSucced, fw fwfailed num: ${fwfailed}, in lsi controller${cardid}, please Check!" | tee -a lsi_update_harddisk.result
        updateResult $diskInfo "all" "default" "failed" "--" $newVersion $updatetime "in lsi controller${cardid}"
    fi
}


function updateDiskLsiFw()
{
    local cardid=$1
    local ctrlModel=$2
    local fwfile=$3
    local newVersion=$4
    local LSI_TOOL=$5
    local retry_times=$6
    local commit_cmd=$7
    local historical_ver=$8
    let retry_times=retry_times+1
    if [ "${historical_ver}" != "N/A" ];then
        local diskInfo="${ctrlModel}|${historical_ver}"
    else
        local diskInfo="${ctrlModel}"
    fi

    local lsi_total_disk=0
    local need_update=0

    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    ${LSI_TOOL} /c$cardid /eall /sall show | grep "${ctrlModel}" > lsi_disk_info.txt
    while read line
    do
        local eid=$(echo $line |awk '{print $1}'| awk -F: '{print $1}')
        local slotid=$(echo $line |awk '{print $1}'| awk -F: '{print $2}')
        local firmware_version=$(${LSI_TOOL} /c$cardid /e$eid /s$slotid show all |grep -i "Firmware Revision" | awk '{print $4}')
        # 因为西数OEM和代理硬盘的 型号相同，历史版本号(固件版本前五位)不同
        # 如HUS726T4TALE6L4，OEM为VKGAW9G0，代理为VKGNW9G0，根据前五位进行判断是OEM还是代理渠道的
        # 所以当硬盘历史版本号为N/A，或者当前固件版本和历史固件版本能匹配上时，硬盘总数才+1
        if [ "${historical_ver}" == "N/A" ] || [[ "x${firmware_version}" =~ "x${historical_ver}" ]];then
            let lsi_total_disk=lsi_total_disk+1
        fi

        if [[ "x${newVersion}" != "x${firmware_version}" ]];then
            if [[ "x${firmware_version}" =~ "x${historical_ver}" ]] || [ "${historical_ver}" = "N/A" ];then
                let need_update=need_update+1
            fi
        fi
        if [ ${need_update} -ne 0 ];then
            if [ "${historical_ver}" != "N/A" ] && [[ ! "x${firmware_version}" =~ "x${historical_ver}" ]];then
                continue
            fi
            local retry_counts=0
            local upgrade_success="False"
            # Tool /cCardID /eEID /sSlotID download src=FW
            update_cmd=$(echo ${commit_cmd} | sed "s%Tool%${LSI_TOOL}%g;s%CardID%${cardid}%g;s%EID%${eid}%g;s%SlotID%${slotid}%g;s%FW%${fwfile}%g")
            echo "lsi update firmware cmd: $update_cmd" >> /tmp/tmp.log
            while [ ${retry_counts} -lt ${retry_times} ]
            do
                $update_cmd >> /tmp/tmp.log
                if [ $? -eq 0 ];then
                    echo "Harddisk ($ctrlModel) update OK, retry_counts:${retry_counts}" >> lsi_harddisk_result.tmp
                    let retry_counts=retry_counts+1
                    upgrade_success="True"
                    break
                else
                    echo "Harddisk ($diskInfo) update failed, retry_counts:${retry_counts}" >> /tmp/tmp.log
                    let retry_counts=retry_counts+1
                    sleep 2
                    continue
                fi
            done
            
            # lsi卡升级一个固件后，需要延时，不然会升级卡死或失败
            if [ ${upgrade_success} == "True" ];then
                echo "It will update next firmware, please wait 80 seconds..."
                sleep 80
            else
                echo "Harddisk ($ctrlModel) update failed, retry_counts:${retry_counts}, please Check!" >> lsi_harddisk_result.tmp
            fi
        fi
    done < lsi_disk_info.txt

    rm -f lsi_disk_info.txt
    
    if [ ${lsi_total_disk} -eq 0 ];then
        greenFont "No harddisk (${diskInfo}) under lsi controller${cardid} in this server, do not need update" | tee -a lsi_update_harddisk.result
        updateResult $diskInfo "--" "default" "success" "--" "--" "0" "no disk in lsi controller${cardid}"
        return 0
    fi
    
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ ${need_update} -eq 0 ];then
        greenFont "Harddisk (${diskInfo}) in lsi controller${cardid} already newVersion(${newVersion}) or not meet the upgrade criteria, do not need update" | tee -a lsi_update_harddisk.result
        updateResult $diskInfo "All" "default" "success" $newVersion $newVersion $updatetime "already newVer in lsi controller${cardid} or not meet the upgrade criteria"
        return 0
    fi

    if [ -f "lsi_harddisk_result.tmp" ];then
        updateDiskLsiFwCheck "lsi_harddisk_result.tmp" "${need_update}" "${ctrlModel}" "${newVersion}" "${updatetime}" "${cardid}" "${diskInfo}"
        rm -f "lsi_harddisk_result.tmp"
    fi
}

function updateDiskLsiFwMain()
{
    ctrlModel=$1
    disk_info=$2
    LSI_TOOL=$3
    local newVersion=$(echo ${disk_info} | awk -F, '{print $1}')
    local fwFile=$(echo ${disk_info} | awk -F, '{print $2}')
    local full_fwfile=${DISK_LSI_FW_DIR}${fwFile}
    local retry_times=$(echo ${disk_info} | awk -F, '{print $3}')
    local commit_cmd=$(echo ${disk_info} | awk -F, '{print $4}')
    local historical_ver=$(echo ${disk_info} | awk -F, '{print $5}')

    if [ ! -f ${LSI_TOOL} ] || [ ! -f "${full_fwfile}" ];then
        redFont "lsi tool or ${fwFile} cat not found, exit upgrade"
        updateResult $ctrlModel "--" "default" "failed" "--" "--" "0" "no tool or fwfile"
        return 0
    fi
    
    # MegaRAID兼容9540-8i，SAS兼容9400/9500HBA卡
    ${LSI_TOOL} show | grep -E "AVAGOMegaRAIDSAS|MegaRAID|SAS|AVAGOJBOD" > lsi_info.txt
    cat lsi_info.txt | while read line
    do
        local flag=$(echo $line |grep -Ec "AVAGOMegaRAIDSAS|MegaRAID|SAS|AVAGOJBOD")
        if [ $flag -ne 0 ];then
            local lsi_cardid=$(echo $line | sed -e 's/^[ \t]*//g'| awk '{print $1}')
            updateDiskLsiFw "${lsi_cardid}" "${ctrlModel}" "${full_fwfile}" "${newVersion}" "${LSI_TOOL}" "${retry_times}" "${commit_cmd}" "${historical_ver}"
        fi
    done
}

function main()
{
    local harddisk_lsi_cfg=$1
    local upgrade_flag=""
    if [ $# -eq 1 ];then
        upgrade_flag="true"
    elif [ $# -gt 1 ] && [ $2 == "list" ];then
        upgrade_flag="false"
    else
        echo "para error return now"
        exit 1
    fi
    
    declare -a lsi_disk_seq
    dosToUnix $harddisk_lsi_cfg
    declare -A lsi_cfg_dict

    while read LINE
    do
        line=$LINE
        if [[ $LINE == \#* ]];then
            continue
        fi
        OLD_IFS="$IFS"
        IFS=","
        configInfo=($LINE)
        IFS="$OLD_IFS"
        model=$(echo ${configInfo[0]})
        new_version=$(echo ${configInfo[1]})
        fwfile=$(echo ${configInfo[2]})
        retry_times=$(echo ${configInfo[3]})
        upgrade_cmd=$(echo ${configInfo[4]})
        historical_version=$(echo ${configInfo[5]})
        if [ "${historical_version}" != "N/A" ];then
            model="${model}|${historical_version}"
        fi
        lsi_disk_seq+=(${model})
        lsi_cfg_dict["${model}"]="${new_version},${fwfile},${retry_times},${upgrade_cmd},${historical_version}"
    done < ${harddisk_lsi_cfg}

    currsegment=0
    totalnum=${#lsi_disk_seq[*]}
    totalsegment=`expr $totalnum \* 2 `

    if [ -d ${LSI_NEW_TOOL_PATH} ];then
        LSI_TOOL_NAME=`ls ${LSI_NEW_TOOL_PATH}`
        LSI_TOOL=${LSI_NEW_TOOL_PATH}"/"${LSI_TOOL_NAME}
    else
        LSI_TOOL=${LSI_OLD_TOOL_PATH}
    fi

    for disk_model in ${lsi_disk_seq[*]}
    do
        local ctrlModel=$(echo ${disk_model} | awk -F "|" '{print $1}')
        if [ ${upgrade_flag} == "true" ];then
            let currsegment=$currsegment+1
            progressinfo=`echo ${ctrlModel} default updating`
            updateDiskLsiFwMain "${ctrlModel}" "${lsi_cfg_dict["${disk_model}"]}" "${LSI_TOOL}"
            let currsegment=$currsegment+1
            progressinfo=`echo ${ctrlModel} default update finished`
        else
            LsiListHardDiskDrive "${ctrlModel}" "${lsi_cfg_dict["${disk_model}"]}" "${LSI_TOOL}"
        fi
    done
}

main $@