#!/bin/bash
#博通网卡固件升级&修改一系列配置&修改package id



BROADCOM_FW_TOOL_NAME="bnxtnvm"
##===================================#
# 功能： BROADCOM信息查询
# 入参：配置文件 各列
#    $1  model    : 网卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，当前固件版本号，位置等信息
##===================================#
function listBroadcomDriveDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "default" ];then
        printf "%-10s %-10s %-12s %-10s %-11s %-8s %-3s\n"   Device  Verdor Model device_name FwType FwVer >>broadcom.list
    fi
    OLD_IFS="$IFS"
    IFS=$'\n'
    local config_version=$newVer
    while read myline
    do
        ctrlModelNum=$(echo $myline |grep $ctrlModel |wc -l)
        if [ ${ctrlModelNum} -ne 0 ];then
            broadcom_ctrlModel=$(echo $myline | awk '{print $1}')
            broadcom_PkgVersion=$(echo $myline | awk '{print $3}')
            device_name=$(echo $myline | awk '{print $2}')
            if [ ${broadcom_PkgVersion} = ${config_version} ];then
                printf "\e[37m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "nic" "broadcom" ${ctrlModel} ${device_name} ${fwType} "${broadcom_PkgVersion}"  >>broadcom.list
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "nic" "broadcom" ${ctrlModel} ${device_name} ${fwType} "${broadcom_PkgVersion}"  >>broadcom.list
            fi
        else
            continue
        fi
    done < $infoFile
    IFS="$OLD_IFS"
    echo -e ""     >>broadcom.list
}

##===================================#
# 功能： BROADCOM网卡信息查询公共
# 入参：配置文件 各列
#     $1  model ：控制器类型;
#     $2  result_file: 输出结果文件;
##===================================#
function get_broadcom_info()
{
    local ctrlModel=$1
    local result_file=$2
    if [ ! -f "${result_file}" ]
    then
        echo "scaning the broadcom nic card in server......."
        modprobe -v bnxt_en  >driverInfo.tmp 2>&1
        ${BROADCOM_FW_TOOL} listdev |grep "Device Interface Name" > broadcom_info.tmp
        while read broadcom_dev
        do
            local device_name=$(echo $broadcom_dev | awk -F: '{print $2}'| sed -e 's/^[ \t]*//g')
            local Part_number=$(${BROADCOM_FW_TOOL} -dev=${device_name} device_info | grep "Part Number" | awk -F: '{print $2}'| sed -e 's/^[ \t]*//g')
            if [ "X${Part_number}" = "X${ctrlModel}" ];then
                local pkg_version=$(ethtool -i $device_name | grep "firmware-version" | awk '{print $3}')
                echo ${ctrlModel} ${device_name} ${pkg_version}>>${result_file}
            fi
        done < broadcom_info.tmp

        if [ ! -f "${result_file}" ];then
            echo "No Broadcom card" >${result_file}
        fi
    fi
}


##===================================#
# 功能： BROADCOM固件信息查询
# 入参：配置文件 各列
#     $1  model ：控制器类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，当前固件版本号，位置等信息。
##===================================#
function listBroadcomDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3

    get_broadcom_info "${ctrlModel}" "BroadcomInfo.tmp"

    local TotalNum=`cat BroadcomInfo.tmp | grep -i ${ctrlModel} | wc -l`

    if [ $fwType = "default" ];then
        echo -e "====================broadcom nic card model(${ctrlModel}) info===================== " >>broadcom.list
                                                
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>broadcom.list                    
    fi
    if [ ${TotalNum} -ne 0 ]
    then 
        listBroadcomDriveDetails "${ctrlModel}" "BroadcomInfo.tmp" "${newVer}" "$fwType"
    fi
}




##===================================#
# 功能：BROADCOM 网卡的固件升级
# 入参:
#       $1 : Nic model:网卡芯片类型
#       $2 : fw_file_path：待升级固件

##===================================#
function updateBroadcomFW()
{
    local ctrlModel=$1
    local fw_file_path=$2
    get_broadcom_info "${ctrlModel}" "updateBroadcomFW.tmp"
    local BroadcomContrlNum=$(cat updateBroadcomFW.tmp | grep ${ctrlModel} | wc -l)

    if [ ${BroadcomContrlNum} -eq 0 ]
    then 
        echo -e "Total broadcom nic card(${ctrlModel}) num: 0,success num : 0" |tee -a broadcom.result
        greenFont "no broadcom nic card (${ctrlModel}) in this server,no need to update" |tee -a broadcom.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no card"
        return 0
    fi
    $RUN_FW_TOOL "${ctrlModel}" "${fw_file_path}" "${BroadcomContrlNum}"

}

##===================================#
# 功能：MLXX的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件
##===================================#
function broadcomMain()
{

    local deviceType=$1
    local vendorType=$2
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"  

    BROADCOM_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${BROADCOM_FW_TOOL_NAME}
    RUN_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${contrlModel}.sh

    if [ ! -f "${BROADCOM_FW_TOOL}" -o ! -d "${fullPathFw}" ] || [ ! -f "${RUN_FW_TOOL}" ]
    then
        redFont " ${BROADCOM_FW_TOOL} or ${fullPathFw} dont exist"
        return 0
    fi
    chmod +x ${BROADCOM_FW_TOOL}
    chmod +x ${RUN_FW_TOOL}
    
    #非配置文件中的参数处理    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then 
    
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listBroadcomDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    case "$contrlModel" in 
    "BCM957414N4140C")
        if [ $deviceType = "nic" -a $vendorType = "BROADCOM" ];then
            updateBroadcomFW "${contrlModel}" "${fullPathFw}" 
        else
            echo "don't support $deviceType or $vendorType"
        fi
        ;;
      *)
        echo "don't support broadcom nic card model :${contrlModel}"
        ;;
    esac
}

broadcomMain $@