#!/bin/bash
SCRIPT_PATH=$(dirname $(readlink -f ${BASH_SOURCE[0]}))
NVME_DISK_FW_DIR="$SCRIPT_PATH/../../../firmware/nvme_general/"
NVME_TOOL="$SCRIPT_PATH/../../tools/nvme_general/nvme"
COMMON_PATH="$SCRIPT_PATH/../cmn/common.sh"
PATHCFG_PATH="$SCRIPT_PATH/../../pathcfg.sh"
source $COMMON_PATH
source $PATHCFG_PATH


##===================================#
# 功能： nvme disk信息查询
# 入参：配置文件 各列
#    $1  model    : 控制卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号,固件类型 序列号，当前固件版本号，位置等信息
##===================================#
function listNvmediskDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3

    printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s\n"   Device  Verdor  Model FwType SerialNum  FwVer Slot >>nvme.list
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do 
        local disk_mode=$(echo ${myline} |awk '{print$1}')
        if [ "x${disk_mode}" = "x${ctrlModel}" ];then
            local FW_Rev=$(echo ${myline} |awk '{print $NF}')
            if [ "${FW_Rev}" != "${newVer}" ];then 
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-20s %-10s %-16s %-8s %-3s \e[0m\n" "nvme_disk" "--" ${ctrlModel} "default" "--"  "${FW_Rev}" "--"  >>nvme.list
            else
                printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s \n" "nvme_disk" "--" ${ctrlModel} "default" "--" "${FW_Rev}" "--"  >>nvme.list
            fi
        fi
    done < $infoFile
    IFS="$OLD_IFS"
}



##===================================#
# 功能： nvme disk固件信息查询
# 入参：配置文件 各列
#     $1  ctrlModel ：硬盘类型;
#     $2  disk_info: 硬盘信息;
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，序列号，当前固件版本号，位置等信息。
##===================================#
function listnvmeDiskDrive()
{
    local ctrlModel=$1
    local disk_info=$2
    local newVer=$(echo ${disk_info}|awk -F, '{print $1}')
    
    if [ ! -f ${NVME_TOOL} ];then
        return 0
    fi

    if [ ! -f "nvme_disk.tmp" ]
    then
        echo "scaning the nvme disk in server......."
        ${NVME_TOOL} list | grep "/dev/nvme" >nvme_disk.tmp
    fi
    rm -f list_nvme_disk_info.tmp
    declare -A map
    while read line
    do
        flag=$(echo ${line} |grep -c "${ctrlModel}")
        if [ $flag -ne 0 ];then
            local Node=$(echo ${line}|awk '{print $1}')
            local FW_Rev=$(echo ${line}|awk '{print $NF}')
            local node_name_simple=$(echo ${Node} |awk -Fn '{print$2}')
            result=${map["${node_name_simple}"]}
            if [ -z "${result}" ];then
                map["${node_name_simple}"]="no exist"
                echo "${ctrlModel}" "${Node}" "${FW_Rev}" >> list_nvme_disk_info.tmp
            fi
        fi
    done < nvme_disk.tmp
    if [ ! -f "list_nvme_disk_info.tmp" ];then
        echo "no this model disk found" > list_nvme_disk_info.tmp
    fi
    local TotalNum=`cat list_nvme_disk_info.tmp | grep $ctrlModel | wc -l`

    echo -e "====================nvme disk model(${ctrlModel}) info===================== " >>nvme.list
    printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>nvme.list

    if [ ${TotalNum} -ne 0 ]
    then 
        listNvmediskDetails "${ctrlModel}" "list_nvme_disk_info.tmp" "${newVer}"
    fi
}


##===================================#
# 功能： nvme disk固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 待升级硬盘个数
#       $3:  待升级硬盘型号
#       $4:  固件类型
#       $5:  待升级固件版本
#       $6:  升级时间
##===================================#
function NvmeUpdateCheck()
{
    local nvme_result=$1
    local nvme_num=$2
    local ctrlModel=$3
    local fwType=$4
    local newVersion=$5
    local updatetime=$6
    fwSucced=$(cat $nvme_result | grep "update OK" | wc -l)

    if [ $fwSucced -eq $nvme_num ];then
        greenFont "total nvme disk ($ctrlModel) need update num:$nvme_num,fw succeed num:$fwSucced" | tee -a nvme.result
        updateResult $ctrlModel "all" "${fwType}" "success" "--" $newVersion $updatetime
    else
        redFont "total nvme disk ($ctrlModel) need update num:$nvme_num,fw succeed num:$fwSucced,please Check!" | tee -a nvme.result
        updateResult $ctrlModel "all" "${fwType}" "failed" "--" $newVersion $updatetime
    fi
}


function updateDisk()
{
    local Node=$1
    local final_fwfile=$2
    local retry_times=$3
    local commit_cmd_final=$4
    local ctrlModel=$5
    local retry_counts=0
    local upgrade_success="false"
    let retry_times=retry_times+1
    while [ ${retry_counts} -lt ${retry_times} ]
    do
        ${NVME_TOOL} fw-download ${Node} -f ${final_fwfile}
        if [ $? -ne 0 ];then
            echo "nvme disk ${ctrlModel} upgrade failed, retry_counts:${retry_counts}" >> /tmp/tmp.log
            let retry_counts=retry_counts+1
            sleep 2
            continue
        else
            echo "nvme disk ${ctrlModel} upgrade success, retry_counts:${retry_counts}" >> /tmp/tmp.log
            upgrade_success="true"
            break
        fi
    done
    
    if [ "${upgrade_success}" == "false" ];then
        echo "nvme disk ($ctrlModel) update failed,please Check!" >>nvme.tmp
    else
        sleep 2
        local commit_retry_counts=0
        local commit_success="false"
        while [ ${commit_retry_counts} -lt ${retry_times} ]
        do
            ${NVME_TOOL} ${commit_cmd_final}
            if [ $? -ne 0 ];then
                echo "nvme disk ${ctrlModel} commit failed, retry_counts:${commit_retry_counts}" >> /tmp/tmp.log
                let commit_retry_counts=commit_retry_counts+1
                sleep 2
                continue
            else
                echo "nvme disk ${ctrlModel} commit success, retry_counts:${commit_retry_counts}" >> /tmp/tmp.log
                commit_success="true"
                break
            fi
        done
        if [ "${commit_success}" == "true" ];then
            echo "nvme disk ($ctrlModel) update OK" >>nvme.tmp
        else
            echo "nvme disk ($ctrlModel) update failed,please Check!" >>nvme.tmp
        fi
    fi
}


##==========================================#
# 功能： nvme硬盘固件升级
#入参说明：
#  $1  待升级的硬盘型号model
#  $2  待升级的硬盘信息，以","分隔的字符串
#  
##==========================================#
function updateNvmeDiskFw()
{
    local ctrlModel=$1
    local disk_info=$2
    local newVersion=$(echo ${disk_info} | awk -F, '{print $1}')
    local fwFile=$(echo ${disk_info} | awk -F, '{print $2}')
    local final_fwfile=${NVME_DISK_FW_DIR}${fwFile}
    local retry_times=$(echo ${disk_info} | awk -F, '{print $3}')
    local commit_cmd=$(echo ${disk_info} | awk -F, '{print $4}')
    local history_version=$(echo ${disk_info} | awk -F, '{print $5}')
    
    if [ ! -f ${NVME_TOOL} ] || [ ! -f "${final_fwfile}" ];then
        redFont "nvme tool or ${fwFile} cat not found,exit upgrade"
        updateResult $ctrlModel "--" "default" "failed" "--" "--" "0" "no tool or fwfile"
        return 0
    fi
    
    rm -f "update_nvme_disk_info.tmp"
    chmod +x ${NVME_TOOL}
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    ${NVME_TOOL} list | grep "/dev/nvme" >total_nvme_disk_info.tmp
    declare -A map
    while read line
    do
        flag=$(echo ${line} |grep -c "${ctrlModel}")
        if [ $flag -ne 0 ];then
            local Node=$(echo ${line}|awk '{print $1}')
            local FW_Rev=$(echo ${line}|awk '{print $NF}')
            local node_name_simple=$(echo ${Node} |awk -Fn '{print$2}')
            result=${map["${node_name_simple}"]}
            if [ -z "${result}" ];then
                map["${node_name_simple}"]="no exist"
                echo "${ctrlModel}" "${Node}" "${FW_Rev}" >> update_nvme_disk_info.tmp
            fi
        fi
    done < total_nvme_disk_info.tmp
    if [ ! -f "update_nvme_disk_info.tmp" ]
    then
        echo -e "Total harddisk (${ctrlModel}) num: 0,success num : 0" |tee -a nvme.result
        greenFont "no harddisk (${ctrlModel}) in this server,no need to update" |tee -a nvme.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no disk"
        return 0
    fi
    
    total_num=$(cat update_nvme_disk_info.tmp|grep -c "${ctrlModel}")
    local need_update_num=0
    while read myline
    do 
        local Node=$(echo ${myline} | awk '{print $2}')
        local FW_Rev=$(echo ${myline} | awk '{print $3}')
        local commit_cmd_final=$(echo ${commit_cmd} |sed "s%nvmenx%${Node}%")
        echo "nvme disk ${ctrlModel} commit cmd : ${commit_cmd_final}" >> /tmp/tmp.log
        if [ ${history_version} == "N/A" ];then
            if [ ${FW_Rev} != "${newVersion}" ];then
                let need_update_num=need_update_num+1
                updateDisk "${Node}" "${final_fwfile}" "${retry_times}" "${commit_cmd_final}" "${ctrlModel}"
            fi
        else
            history_version_flag=$(echo ${FW_Rev} |grep -c "${history_version}")
            if [ ${history_version_flag} -ne 0 ];then
                let need_update_num=need_update_num+1
                updateDisk "${Node}" "${final_fwfile}" "${retry_times}" "${commit_cmd_final}" "${ctrlModel}"
            fi
        fi
    done < update_nvme_disk_info.tmp
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ ${need_update_num} -eq 0 ];then
        greenFont "all nvme disk (${ctrlModel}) is new version(${newVersion}) in this server or not meet the upgrade criteria,no need to update " |tee -a nvme.result
        updateResult $ctrlModel "all" "default" "success" $newVersion $newVersion $updatetime
        return 0
    fi
    if [ -f "nvme.tmp" ];then
        NvmeUpdateCheck "nvme.tmp" "$need_update_num" "$ctrlModel" "default" "$newVersion" "$updatetime"
        rm -f "nvme.tmp"
    fi
    
}


function nvme_main()
{
    local nvme_cfg=$1
    local upgrade_flag=""
    if [ $# -eq 1 ];then
        upgrade_flag="true"
    elif [ $# -gt 1 ] && [ $2 == "list" ];then
        upgrade_flag="false"
    else
        echo "para error return now"
        exit 1
    fi
    declare -a nvme_disk_seq
    dosToUnix $nvme_cfg
    declare -A nvmecfg_dict

    while read LINE
    do
       line=$LINE
       if [[ $LINE == \#* ]];then
           continue
       fi
       OLD_IFS="$IFS"
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS"
       model=$(echo ${configInfo[0]})
       version=$(echo ${configInfo[1]})
       fwfile=$(echo ${configInfo[2]})
       retry_times=$(echo ${configInfo[3]})
       upgrade_cmd=$(echo ${configInfo[4]})
       history_version=$(echo ${configInfo[5]})
       nvme_disk_seq+=(${model})
       nvmecfg_dict["${model}"]="${version},${fwfile},${retry_times},${upgrade_cmd},${history_version}"
    done < ${nvme_cfg}
    totalnum=${#nvme_disk_seq[*]}
    totalsegment=`expr $totalnum \* 2 `
    currsegment=0
    for disk_model in ${nvme_disk_seq[*]}
    do
        local ctrlModel=$(echo ${disk_model} | awk -F "|" '{print $1}')
        if [ ${upgrade_flag} == "true" ];then
            let currsegment=$currsegment+1
            progressinfo=`echo ${ctrlModel}  default updating`
            updateProgress $currsegment $totalsegment "$progressinfo"
            updateNvmeDiskFw "${ctrlModel}" "${nvmecfg_dict["${disk_model}"]}"
            let currsegment=$currsegment+1
            progressinfo=`echo ${ctrlModel} default update finished`
            updateProgress $currsegment $totalsegment "$progressinfo"
        else
            listnvmeDiskDrive "${ctrlModel}" "${nvmecfg_dict["${disk_model}"]}"
        fi
    done  
}

nvme_main $@