#!/bin/bash
# lsi控制器升级希捷硬盘

ORA_PATH=`pwd`
LOCAL_COMMON_ENTRY=$ORA_PATH"/scripts/cmn/common.sh"
PATHCFG_ENTRY=$ORA_PATH"/""pathcfg.sh"

function lsi_update_disk()
{
    local model=$1
    local cardid=$2
    local eid=$3
    local slotid=$4
    local fwfile=$5
    local fwtype=$6
    local newVersion=$7
    ${lsi_tool} /c$cardid /e$eid /s$slotid download src=$fwfile
    if [ $? -eq 0 ];then
        echo "samsung disk ($model) $fwtype update OK" >>samsung_lsi_result.tmp
    else
        echo "samsung disk ($model) $fwtype update failed,please Check!" >>samsung_lsi_result.tmp
    fi
    # lsi卡升级一个固件后，需要延时，不然会升级卡死或失败
    echo "it will update next firmware ,please wait 80 seconds ..."
    sleep 80
}



function SamsungLsiUpdateCheck()
{
    local result_file=$1
    local fwtype=$2
    local update_num=$3
    local model=$4
    local newVersion=$5
    local updatetime=$6
    local cardid=$7
    fwsuccess=$(cat ${result_file} |grep -c "fw update OK")
    fwfailed=$(cat ${result_file} |grep -c "fw update failed,please Check")
    if [ "x${fwtype}" = "xfw" ];then
        if [ ${fwfailed} -eq 0 ];then
            greenFont "total samsung disk in lsi controller${cardid} need update($model) num:$update_num,fw succeed num:$fwsuccess,fw failed num:$fwfailed" |tee -a samsung.result
            updateResult $model "all" "${fwtype}" "success" "--" $newVersion $updatetime "in lsi controller${cardid}"
        else
            redFont "total samsung disk in lsi controller${cardid} need update($model) num:$update_num,fw succeed num:$fwsuccess,fw failed num:$fwfailed, please check!!" |tee -a samsung.result
            updateResult $model "all" "${fwtype}" "failed" "--" $newVersion $updatetime "in lsi controller${cardid}"
        fi
    fi
}




function samsung_lsi_main()
{
    local cardid=$1
    local disk_model=$2
    local fwfile=$3
    local newVersion=$4
    local fwtype=$5
    lsi_tool=$6
    local lsi_total_disk=0
    local already_new_version=0
    local need_update=0
    source $LOCAL_COMMON_ENTRY
    source $PATHCFG_ENTRY
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    ${lsi_tool} /c$cardid /eall /sall show |grep "SAMSUNG" |grep "${disk_model}"> lsi_disk_info.txt
    while read line
    do
        let lsi_total_disk=lsi_total_disk+1
        local eid=$(echo $line |awk '{print $1}'| awk -F: '{print $1}')
        local slotid=$(echo $line |awk '{print $1}'| awk -F: '{print $2}')
        local firmware_version=$(${lsi_tool} /c$cardid /e$eid /s$slotid show all |grep -i "Firmware Revision"|awk '{print $4}')
        if [ "x$firmware_version" = "x$newVersion" ];then
            let already_new_version=already_new_version+1
        else
            lsi_update_disk "${disk_model}" "${cardid}" "${eid}" "${slotid}" "${fwfile}" "${fwtype}" "${newVersion}"
        fi
    done < lsi_disk_info.txt
    rm -f lsi_disk_info.txt
    let need_update=lsi_total_disk-already_new_version
    
    if [ ${lsi_total_disk} -eq 0 ];then
        greenFont "no samsung disk (${disk_model}) under lsi controller${cardid} in this server,do not need update ${fwtype}" | tee -a samsung.result
        updateResult $disk_model "--" "$fwtype" "success" "--" "--" "0" "no disk in lsi controller${cardid}"
        return 0
    fi
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ ${need_update} -eq 0 ];then
        greenFont "all samsung disk (${disk_model}) in lsi controller{cardid} fwtype (${fwtype}) already newversion,do not need update" | tee -a samsung.result
        updateResult $disk_model "all" "$fwtype" "success" $newVersion $newVersion $updatetime "in lsi controller${cardid}"
        return 0
    fi

    if [ -f "samsung_lsi_result.tmp" ];then
        SamsungLsiUpdateCheck "samsung_lsi_result.tmp" "$fwtype" "$need_update" "$disk_model" "${newVersion}" "${updatetime}" "${cardid}"
        rm -f "samsung_lsi_result.tmp"
    fi
}



samsung_lsi_main $@