#!/bin/bash

chmod 777 *.sh

source pathcfg.sh

chmod 777 -R "$SCRIPT_PATH/scripts"

source $SCRIPT_PATH$COMMON_ENTRY

CFG_FILE_COLUMN_NUM=7   #ļеĸ

source ${TOPO_ENTRY}
##===================================#
# ܣ ļһ òͬ豸Ĺ̼ű
# Σļ 
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 ̼Ĺ·
#     $7  ̼İ汾ļ
##===================================#
function  categorizeDevice()
{
    
    case "$1" in
     "harddisk")
      source $SCRIPT_PATH$HARD_DISK_ENTRY $@
      ;;
     "raid")
      source $SCRIPT_PATH$RAID_CARD_ENTRY $@
      ;;
     "nic")
      source $SCRIPT_PATH$NETWORK_CARD_ENTRY $@
      ;;
     "fc")
      source $SCRIPT_PATH$FC_CARD_ENTRY $@
      ;;
	  "expander")
      source $SCRIPT_PATH$EXPANDER_ENTRY $@
      ;;
    *)
      echo "don't support device " $1
      ;;
    esac
}
##===================================#
# ܣļĻصӿ
# Σļ 
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 ̼Ĺ·
#     $7  ̼İ汾ļ
##===================================#
function fwMainCB()
{
   setEnvVar $@
   categorizeDevice $@
}

##===================================#
# ܣ ѯ豸Ϣ
##===================================#

function fwList()
{       
    for file in `find ./ -name "*.list"`
    do
       cat ${file}
       rm -rf ${file}
    done   
    
}

function fwListDiskLsi()
{
    listTopo
    $SCRIPT_PATH$HARD_DISK_GENERAL_LSI_ENTRY "${HARDDISK_CONFIG_LSI_NAME}" "list"
    fwList
    updateTips
}

function fwListDrives_nvme()
{
    listTopo
    $SCRIPT_PATH$NVME_GENERAL_ENTRY "${NVME_CONFIG_NAME}" "list"
    fwList
    updateTips
}

function fwListDiskPmc()
{
    listTopo
    $SCRIPT_PATH$HARD_DISK_GENERAL_PMC_ENTRY "${HARDDISK_CONFIG_PMC_NAME}" "list"
    fwList
    updateTips
}

function fwListDiskBridge()
{
    listTopo
    $SCRIPT_PATH$HARD_DISK_GENERAL_BRIDGE_ENTRY "${HARDDISK_CONFIG_BRIDGE_NAME}" "list"
    fwList
    updateTips
}

##===================================#
# ܣ ѯ豸Ϣ,ʾϢ
##===================================#

function fwListDrives()
{
    listTopo
    parseConf fw.csv fwMainCB ${CFG_FILE_COLUMN_NUM} "list" 
    fwList
    updateTips 
}
##===================================#
# ܣ ĽϢ
##===================================#
function fwUpdateResult()
{
    echo -e "===============all fw update result==============="
    for file in `find ./ -name "*.result"`
    do
       cat ${file} |tee -a ${UPDATE_LOG}
       rm -rf ${file}
    done
}

function fwUpdate_nvme()
{
    local nvmecfg=$1
    $SCRIPT_PATH$NVME_GENERAL_ENTRY "${nvmecfg}"
    fwList
    fwUpdateResult
    
    echo "===================================Drive List================================" >> ${UPDATE_LOG}
    fwListDrives_nvme >> ${UPDATE_LOG}
    
    
    #log ڣ Ƿ "please Check!" ,ļ
    if [ -f  ${UPDATE_LOG} ]
    then
        updateResultFlag=`cat ${UPDATE_LOG} |grep "please Check!"`
        echo ${updateResultFlag}

        if [ -z "${updateResultFlag}" ]
        then
          mv ${UPDATE_LOG} ${UPDATE_SUCCESS_LOG}
          echo "Update log : ${UPDATE_SUCCESS_LOG}"
        else
          mv ${UPDATE_LOG} ${UPDATE_FAIL_LOG}
          echo "Update log : ${UPDATE_FAIL_LOG}"
        fi
    fi
}

function fwUpdate_harddisk_lsi()
{
    local harddisk_lsi_cfg=$1
    $SCRIPT_PATH$HARD_DISK_GENERAL_LSI_ENTRY "${harddisk_lsi_cfg}"
    fwList
    fwUpdateResult

    echo "===================================Drive List================================" >> ${UPDATE_LOG}
    fwListDiskLsi >> ${UPDATE_LOG}
    
    
    #log ڣ Ƿ "please Check!" ,ļ
    if [ -f  ${UPDATE_LOG} ]
    then
        updateResultFlag=`cat ${UPDATE_LOG} |grep "please Check!"`
        echo ${updateResultFlag}

        if [ -z "${updateResultFlag}" ]
        then
          mv ${UPDATE_LOG} ${UPDATE_SUCCESS_LOG}
          echo "Update log : ${UPDATE_SUCCESS_LOG}"
        else
          mv ${UPDATE_LOG} ${UPDATE_FAIL_LOG}
          echo "Update log : ${UPDATE_FAIL_LOG}"
        fi
    fi
}

function fwUpdate_harddisk_pmc()
{
    local harddisk_pmc_cfg=$1
    $SCRIPT_PATH$HARD_DISK_GENERAL_PMC_ENTRY "${harddisk_pmc_cfg}"
    fwList
    fwUpdateResult

    echo "===================================Drive List================================" >> ${UPDATE_LOG}
    fwListDiskPmc >> ${UPDATE_LOG}
    
    
    #log ڣ Ƿ "please Check!" ,ļ
    if [ -f  ${UPDATE_LOG} ]
    then
        updateResultFlag=`cat ${UPDATE_LOG} |grep "please Check!"`
        echo ${updateResultFlag}

        if [ -z "${updateResultFlag}" ]
        then
          mv ${UPDATE_LOG} ${UPDATE_SUCCESS_LOG}
          echo "Update log : ${UPDATE_SUCCESS_LOG}"
        else
          mv ${UPDATE_LOG} ${UPDATE_FAIL_LOG}
          echo "Update log : ${UPDATE_FAIL_LOG}"
        fi
    fi
}

function fwUpdate_harddisk_bridge()
{
    local harddisk_bridge_cfg=$1
    $SCRIPT_PATH$HARD_DISK_GENERAL_BRIDGE_ENTRY "${harddisk_bridge_cfg}"
    fwList
    fwUpdateResult

    echo "===================================Drive List================================" >> ${UPDATE_LOG}
    fwListDiskBridge >> ${UPDATE_LOG}
    
    #log ڣ Ƿ "please Check!" ,ļ
    if [ -f  ${UPDATE_LOG} ]
    then
        updateResultFlag=`cat ${UPDATE_LOG} | grep "please Check!"`
        echo ${updateResultFlag}

        if [ -z "${updateResultFlag}" ]
        then
          mv ${UPDATE_LOG} ${UPDATE_SUCCESS_LOG}
          echo "Update log : ${UPDATE_SUCCESS_LOG}"
        else
          mv ${UPDATE_LOG} ${UPDATE_FAIL_LOG}
          echo "Update log : ${UPDATE_FAIL_LOG}"
        fi
    fi
}

##===================================#
# ܣ й̼ĸ
# Σ $1 ļ
#        fw.csv 
#        fwtest.csv 
##===================================#

function fwUpdate()
{
    rm -f ${UPDATE_LOG}
    rm -f ${UPDATE_SUCCESS_LOG}
    rm -f ${UPDATE_FAIL_LOG}
    rm -f ${UPDATE_PROCESS_LOG}
    # rm -f ${UPDATE_RESULT_LOG}
    
    if [ -f '/usr/bin/ifconfig' ];then
        ifconfig |grep addr -B 2 >>${UPDATE_LOG}
    fi
    
    parseConf ${1} fwMainCB ${CFG_FILE_COLUMN_NUM}
    fwList
    fwUpdateResult
    
    echo "===================================Drive List================================" >> ${UPDATE_LOG}
    fwMain -l >> ${UPDATE_LOG}
    
    
    #log ڣ Ƿ "please Check!" ,ļ
    if [ -f  ${UPDATE_LOG} ]
    then
        updateResultFlag=`cat ${UPDATE_LOG} |grep "please Check!"`
        echo ${updateResultFlag}

        if [ -z "${updateResultFlag}" ]
        then
          mv ${UPDATE_LOG} ${UPDATE_SUCCESS_LOG}
          echo "Update log : ${UPDATE_SUCCESS_LOG}"
        else
          mv ${UPDATE_LOG} ${UPDATE_FAIL_LOG}
          echo "Update log : ${UPDATE_FAIL_LOG}"
        fi
    fi
    
}

##===================================#
# ܣ ͷмļ
##===================================#
function fwReleaseTmp()
{
    for file in `find ./ -name "*.tmp"`
    do 
       rm -rf ${file}
    done
}
##===================================#
# ܣ  ̼ܰ˵
##===================================#
function fwUsage()
{
    echo "Usage:"
    echo "    fwupdate.sh        update fw"
    echo "    fwupdate.sh -l     list updated device"

}
##===================================#
# ܣ ̼ں
##===================================#
function fwMain()
{  
       
    # Ϊ 0ֱ
    #1ʾusage
    # 1ز
    # nvmeͨļڣnvmeͨ
    # ҪǶraidڲ
    local upgrade_process="general"
    declare -a upgrade_list
    if [ -f $NVME_CONFIG_NAME ] && [ $(cat ${CONFIG_NAME}|grep -c "NVME_DISK") -ne 0 ];then
        upgrade_list+=("nvme_disk_upgrade")
    fi
    if [ -f $HARDDISK_CONFIG_LSI_NAME ] && [ $(cat ${CONFIG_NAME} | grep -c "LSI_DISK") -ne 0 ];then
        upgrade_list+=("lsi_disk_upgrade")
    fi
    if [ -f $HARDDISK_CONFIG_PMC_NAME ] && [ $(cat ${CONFIG_NAME} | grep -c "PMC_DISK") -ne 0 ];then
        upgrade_list+=("pmc_disk_upgrade")
    fi

    if [ -f $HARDDISK_CONFIG_BRIDGE_NAME ] && [ $(cat ${CONFIG_NAME} | grep -c "BRIDGE_DISK") -ne 0 ];then
        upgrade_list+=("bridge_disk_upgrade")
    fi

    listnum=${#upgrade_list[*]}
    if [  $# -eq 0 ]
    then
        if [ ${listnum} -eq 0 ];then
            echo "upgrade_process is ${upgrade_process}"
            if [ "${upgrade_process}" == "general" ];then
                fwUpdate ${CONFIG_NAME}
            fi
        else
            for upgrade_pro in ${upgrade_list[*]}
            do
                echo "upgrade_pro is ${upgrade_pro}"
                case "${upgrade_pro}" in
                "nvme_disk_upgrade")
                    fwUpdate_nvme "${NVME_CONFIG_NAME}"
                    ;;
                "lsi_disk_upgrade")
                    fwUpdate_harddisk_lsi "${HARDDISK_CONFIG_LSI_NAME}"
                    ;;
                "pmc_disk_upgrade")
                    fwUpdate_harddisk_pmc "${HARDDISK_CONFIG_PMC_NAME}"
                    ;;
                "bridge_disk_upgrade")
                    fwUpdate_harddisk_bridge "${HARDDISK_CONFIG_BRIDGE_NAME}"
                    ;;
                esac
            done
        fi
        updateProgress 19 18 "log is being generated"
        python3.7 analyse_result.py
    fi  
    if [ $# -eq 1 ]
    then
        case "${1}" in 
        -l)
            if [ ${listnum} -eq 0 ];then
                echo "upgrade_process is ${upgrade_process}"
                if [ "${upgrade_process}" == "general" ];then
                    fwListDrives
                fi
            else
                for upgrade_pro in ${upgrade_list[*]}
                do
                    echo "upgrade_pro is ${upgrade_pro}"
                    case "${upgrade_pro}" in
                    "nvme_disk_upgrade")
                        fwListDrives_nvme
                        ;;
                    "lsi_disk_upgrade")
                        fwListDiskLsi
                        ;;
                    "pmc_disk_upgrade")
                        fwListDiskPmc
                        ;;
                    "bridge_disk_upgrade")
                        fwListDiskBridge
                        ;;
                    esac
                done
            fi
            ;;
        -d)
           fwUpdate ${TEST_CONFIG_NAME}             
           ;;
        *) 
           fwUsage          
            ;;
        esac            
    fi
    
    if [ $# -gt 1 ]
    then 
        fwUsage
    fi
}

rm -f ${NEED_UPDATE_FLAG}

startTimeSec=`date +%s`
showVer


fwMain $@

fwReleaseTmp

sync
endTimeSec=`date +%s`


echo "time elapse: $((endTimeSec-startTimeSec)) seconds"
