#!/bin/bash
SUPPORT_MODEL="R5500G4"
##===================================#
# 功能：判断服务器的型号是否为R5500G4,目前只支持R5500G4的升级
##===================================#
RET=1
function serve_model_check()
{
  baseboard=$(dmidecode -t baseboard |grep "Product Name" |awk '{print $3}')
  if [ ${baseboard} != ${SUPPORT_MODEL} ]
  then
      echo "The current server:${baseboard} does not support updating the expander"
	  RET=0
  else
      echo "The current server:${baseboard} ,updating will start now"
      RET=1 
   fi   
}

function categorizeVendor()
{
   serve_model_check
   echo "RET=${RET}"
   if [ ${RET} -eq 0 ]
   then 
        echo "serve_model check failure" 
		return 0
   else
		case "$2"  in
		  "GOOXI")
		   source $SCRIPT_PATH$GOOXIBM_ENTRY $@
		   ;;		  
		  *)
		   echo "don't support vendor " $2
		   ;;
		esac 
    fi		
}

categorizeVendor $@
