#!/bin/bash
SCRIPT_PATH=$(dirname $(readlink -f ${BASH_SOURCE[0]}))
DISK_PMC_FW_DIR="$SCRIPT_PATH/../../../firmware/pmc/"
PMC_NEW_TOOL_PATH="$SCRIPT_PATH/../../tools/pmc_new/"
SMARTCTL_PATH="/usr/bin/smartctl6.7-linux"
PMC_OLD_TOOL_PATH="$SCRIPT_PATH/../../tools/pmc/arcconf-linux"
COMMON_PATH="$SCRIPT_PATH/../cmn/common.sh"
PATHCFG_PATH="$SCRIPT_PATH/../../pathcfg.sh"
source $COMMON_PATH
source $PATHCFG_PATH


function updateFwPmcList()
{
    local ctrlModel=$1
    local disk_info=$2
    PMC_TOOL=$3
    local newVersion=$(echo ${disk_info} | awk -F, '{print $1}')
    local historicalVer=$(echo ${disk_info} | awk -F, '{print $5}')
    if [[ "${historicalVer}" != "N/A" ]];then
        local diskInfo="${ctrlModel}, ${historicalVer}, pmc"
    else
        local diskInfo="${ctrlModel}, pmc"
    fi   

    declare -A sn_model_dict
    getAllDisk ${sn_model_dict}

    if [ ! -f pmc_harddisk.list ];then
        echo "scaning harddisk in pmc controller in server ......"
    fi

    ${PMC_TOOL} list > pmc_info.txt
    cat pmc_info.txt | while read line
    do
        pmc_flag_2100=$(echo $line |grep -c "IOC2100")
        pmc_flag_3100=$(echo $line |grep -c "ROC3100")
        Flag3152_8i=$(echo $line |grep -c "3152-8i")
        Flag3154_16i=$(echo $line |grep -c "3154-16i")
        if [ ${pmc_flag_2100} -ne 0 ] || [ ${pmc_flag_3100} -ne 0 ] || [ ${Flag3152_8i} -ne 0 ] || [ ${Flag3154_16i} -ne 0 ];then
            local cardid=$(echo $line | awk -F ':' '{print $1}'| awk '{print $NF}')
            ${PMC_TOOL} getconfig $cardid pd |sed -n '/Device is a Hard drive/,/Serial number\s*:/p'| grep -v 'Array' > pmc_disk_info.txt
            local exist_disk_flag=$(cat pmc_disk_info.txt |grep -c "Device is a Hard drive")
            if [ ${exist_disk_flag} -eq 0 ];then
                return 0
            fi
            sed -i '/Device is a Hard drive/i\|' pmc_disk_info.txt
            disk_info_string=$(cat pmc_disk_info.txt)
            OLD_IFS="$IFS"
            IFS="|"
            local disk_info_arr=($disk_info_string)
    
            IFS="$OLD_IFS"
            local arr_length=${#disk_info_arr[@]}
            let disk_num=arr_length-1
            for((i=1;i<=$disk_num;i++))
            do
                local single_disk_info=${disk_info_arr[i]}
                local model_tmp=$(echo "${single_disk_info}" | grep "Model" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
                local Firmware=$(echo "${single_disk_info}" | grep "Firmware" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
                local SN=$(echo "${single_disk_info}" | grep "Serial number" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
                if [ ! -z "${sn_model_dict["${SN}"]}" ];then
                    model_tmp=$(echo "${model_tmp}" | sed -e 's/[ \t]*//g')
                    if [[ "${sn_model_dict["${SN}"]}" =~ "${ctrlModel}" ]] && [[ "${sn_model_dict["${SN}"]}" =~ "${model_tmp}" ]];then
                        if [ "${Firmware}" = "${newVersion}" ];then 
                            printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s \n" "harddisk" "--"  ${ctrlModel} "default" ${SN} ${Firmware} "--">> pmc_disk_tmp.txt
                        elif [[ "x${Firmware}" =~ "x${historicalVer}" ]] || [ "${historicalVer}" = "N/A" ];then
                            echo "need update" >>${NEED_UPDATE_FLAG}
                            printf "\e[31m%-10s %-10s %-20s %-10s %-16s %-8s %-3s \e[0m\n" "harddisk" "--" ${ctrlModel} "default" ${SN} ${Firmware} "--" >> pmc_disk_tmp.txt
                        fi
                    fi
                fi
            done
        fi
    done
    rm pmc_info.txt
    if [ ! -f "pmc_disk_tmp.txt" ];then
        echo "no harddisk " >> pmc_disk_tmp.txt
    fi

    local TotalNum=$(cat pmc_disk_tmp.txt| grep "$ctrlModel"|wc -l)
    local ModelNum=0
    if [ -f pmc_harddisk.list ];then
        ModelNum=$(cat pmc_harddisk.list| grep "$diskInfo"|wc -l)
    fi
    if [ ${ModelNum} -eq 0 ];then
        echo -e "====================Harddisk model(${diskInfo}) info===================== " >> pmc_harddisk.list
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >> pmc_harddisk.list
        printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s\n"   Device  Verdor  Model FwType SerialNum  FwVer Slot >> pmc_harddisk.list
    
        cat pmc_disk_tmp.txt | grep "$ctrlModel" >> pmc_harddisk.list
    fi
    rm -f pmc_disk_tmp.txt
}

function updateDiskPmcFwCheck()
{
    # "pmc_harddisk_result.tmp" "${need_update}" "${ctrlModel}" "${newVersion}" "${updatetime}" "${cardid}"
    resultFile=$1
    need_update=$2
    ctrlModel=$3
    newVersion=$4
    updatetime=$5
    cardid=$6
    local diskInfo=$7

    fwSucced=$(cat $resultFile | grep "update OK" | wc -l)
    fwfailed=$(cat $resultFile | grep "fw update failed,please Check" | wc -l)

    if [ $fwSucced -eq $need_update ];then
        greenFont "Total harddisk ($diskInfo) need update num:$need_update, fw succeed num: $fwSucced, fw failed num: $fwfailed, in pmc controller${cardid}" | tee -a pmc_update_harddisk.result
        updateResult $diskInfo "all" "default" "success" "--" $newVersion $updatetime "in pmc controller${cardid}"
    else
        redFont "Total harddisk ($diskInfo) need update num:$need_update, fw succeed num: $fwSucced, fw failed num: $fwfailed, in pmc controller${cardid}, please Check!" | tee -a pmc_update_harddisk.result
        updateResult $diskInfo "all" "default" "failed" "--" $newVersion $updatetime "in pmc controller${cardid}"
    fi
}

function updateDiskPmcFw()
{
    local cardid=$1
    local ctrlModel=$2
    local fwfile=$3
    local newVersion=$4
    local pmc_tool=$5
    local retry_times=$6
    local commit_cmd=$7
    local historical_ver=$8
    let retry_times=retry_times+1

    local pmc_total_disk=0
    local need_update=0
    
    if [ ${historical_ver} != "N/A" ];then
        local diskInfo="${ctrlModel}|${historical_ver}"
    else
        local diskInfo="${ctrlModel}"
    fi
    
    ${PMC_TOOL} getconfig $cardid pd |sed -n '/Device is a Hard drive/,/Serial number\s*:/p'| grep -v 'Array' > pmc_disk_info.txt
    local exist_disk_flag=$(cat pmc_disk_info.txt |grep -c "Device is a Hard drive")
    if [ ${exist_disk_flag} -eq 0 ];then
        greenFont "No disk (${diskInfo}) in pmc controller, do not need update"
        updateResult $diskInfo "--" "default" "success" "--" "--" "0" "no disk in pmc controller${cardid}"
        return 0
    fi
    sed -i '/Device is a Hard drive/i\|' pmc_disk_info.txt
    disk_info_string=$(cat pmc_disk_info.txt)
    OLD_IFS="$IFS"
    IFS="|"
    local disk_info_arr=($disk_info_string)
    
    IFS="$OLD_IFS"
    local arr_length=${#disk_info_arr[@]}
    let disk_num=arr_length-1
    
    declare -A sn_model_dict
    getAllDisk ${sn_model_dict}
 
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    
    for((i=1;i<=$disk_num;i++))
    do
        local single_disk_info=${disk_info_arr[i]}
        local channel_device_info=$(echo "${single_disk_info}" |grep "Reported Channel,Device" | awk '{print $NF}'|awk -F "(" '{print $1}')
        local channel=$(echo ${channel_device_info} | awk -F, '{print $1}')
        local device=$(echo ${channel_device_info} | awk -F, '{print $2}')
        local model_tmp=$(echo "${single_disk_info}" | grep "Model" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        local Firmware=$(echo "${single_disk_info}" | grep "Firmware" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        local SN=$(echo "${single_disk_info}" | grep "Serial number" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        model_match_flag=0
        # arcconf工具得到的硬盘型号不完整，需要通过smartctl工具获取完整型号，以sn为key值，比较型号是否匹配
        if [ ! -z "${sn_model_dict["${SN}"]}" ];then
            model_tmp=$(echo "${model_tmp}" | sed -e 's/[ \t]*//g')
            if [[ "${sn_model_dict["${SN}"]}" =~ "${ctrlModel}" ]] && [[ "${sn_model_dict["${SN}"]}" =~ "${model_tmp}" ]];then
                echo "Same info: sn is ${SN}, model is ${sn_model_dict["${SN}"]}" >> /tmp/tmp.log
                model_match_flag=1
            fi
        else
            echo "Not found same SN through arcconf and smartctl, please confirm SN(${SN}), model(${model_tmp})" >> /tmp/tmp.log
        fi
        # 因为西数OEM和代理硬盘的 型号相同，历史版本号(固件版本前五位)不同
        # 如HUS726T4TALE6L4，OEM为VKGAW9G0，代理为VKGNW9G0，根据前五位进行判断是OEM还是代理渠道的
        # 所以当硬盘历史版本号为N/A，或者当前固件版本和历史固件版本能匹配上时，硬盘总数才+1
        if [ ${model_match_flag} -ne 0 ];then
            if [ "${historical_ver}" = "N/A" ] || [[ "x${Firmware}" =~ "x${historical_ver}" ]];then
                let pmc_total_disk=pmc_total_disk+1
            fi
        fi
        
        if [ ${model_match_flag} -ne 0 ];then
            if [[ "x${newVersion}" != "x${Firmware}" ]];then
                if [[ "x${Firmware}" =~ "x${historical_ver}" ]] || [ "${historical_ver}" = "N/A" ];then
                    let need_update=need_update+1
                fi
            fi

            if [ ${need_update} -ne 0 ];then
                if [ "${historical_ver}" != "N/A" ] && [[ ! "x${Firmware}" =~ "x${historical_ver}" ]];then
                    continue
                fi
                local retry_counts=0
                local upgrade_success="False"
                update_cmd=$(echo ${commit_cmd} | sed "s%Tool%${pmc_tool}%g;s%CardID%${cardid}%g;s%ChannelID%${channel}%g;s%DeviceID%${device}%g;s%FW%${fwfile}%g")
                # Tool imageupdate CardID device ChannelID DeviceID 32768 FW 239 noprompt
                # ${PMC_TOOL} imageupdate ${cardid} device ${channel} ${device} 32768 ${fwfile} 239 noprompt
                echo "pmc update firmware cmd:$update_cmd" >> /tmp/tmp.log
                while [ ${retry_counts} -lt ${retry_times} ]
                do
                    $update_cmd >> /tmp/tmp.log
                    if [ $? -eq 0 ];then
                        echo "Harddisk($ctrlModel) update OK, retry_counts:${retry_counts}" >> pmc_harddisk_result.tmp
                        let retry_counts=retry_counts+1
                        upgrade_success="True"
                        break
                    else
                        echo "Harddisk ($diskInfo) update failed, retry_counts:${retry_counts}" >> /tmp/tmp.log
                        let retry_counts=retry_counts+1
                        sleep 2
                        continue
                    fi
                done
                if [ ${upgrade_success} == "False" ];then
                     echo "Harddisk ($ctrlModel) update failed, retry_counts:${retry_counts}" >> pmc_harddisk_result.tmp
                fi
            fi
        fi
    done

    if [ ${pmc_total_disk} -eq 0 ];then
        greenFont "No harddisk(${diskInfo}) in pmc controller${cardid} in this server, do not need update" | tee -a pmc_update_harddisk.result
        updateResult $diskInfo "--" "default" "success" "--" "--" "0" "no disk in pmc controller${cardid}"
        return 0
    fi
    
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ ${need_update} -eq 0 ];then
        greenFont "All harddisk (${diskInfo}) in pmc controller${cardid} already newVersion(${newVersion}) or not meet the upgrade criteria, do not need update" | tee -a pmc_update_harddisk.result
        updateResult $diskInfo "all" "default" "success" $newVersion $newVersion $updatetime "already newVer in lsi controller${cardid} or not meet the upgrade criteria"
        return 0
    fi

    if [ -f "pmc_harddisk_result.tmp" ];then
        updateDiskPmcFwCheck "pmc_harddisk_result.tmp" "${need_update}" "${ctrlModel}" "${newVersion}" "${updatetime}" "${cardid}" "${diskInfo}"
        rm -f "pmc_harddisk_result.tmp"
    fi

}

function updateDiskPmcFwMain()
{
    ctrlModel=$1
    disk_info=$2
    local newVersion=$(echo ${disk_info} | awk -F, '{print $1}')
    local fwFile=$(echo ${disk_info} | awk -F, '{print $2}')
    local full_fwfile=${DISK_PMC_FW_DIR}${fwFile}
    local retry_times=$(echo ${disk_info} | awk -F, '{print $3}')
    local commit_cmd=$(echo ${disk_info} | awk -F, '{print $4}')
    local historical_ver=$(echo ${disk_info} | awk -F, '{print $5}')
    PMC_TOOL=$3

    if [ ! -f ${PMC_TOOL} ] || [ ! -f "${full_fwfile}" ];then
        redFont "pmc tool or ${fwFile} cannot found, exit upgrade"
        updateResult $ctrlModel "--" "default" "failed" "--" "--" "0" "no tool or fwfile"
        return 0
    fi

    ${PMC_TOOL} list > pmc_info.txt
    cat pmc_info.txt | while read line
    do
        pmc_flag_2100=$(echo $line |grep -c "IOC2100")
        pmc_flag_3100=$(echo $line |grep -c "ROC3100")
        Flag3152_8i=$(echo $line |grep -c "3152-8i")
        Flag3154_16i=$(echo $line |grep -c "3154-16i")
        if [ ${pmc_flag_2100} -ne 0 ] || [ ${pmc_flag_3100} -ne 0 ] || [ ${Flag3152_8i} -ne 0 ] || [ ${Flag3154_16i} -ne 0 ];then
            local cardid=$(echo $line | awk -F ':' '{print $1}'| awk '{print $NF}')
            updateDiskPmcFw "${cardid}" "${ctrlModel}" "${full_fwfile}" "${newVersion}" "${PMC_TOOL}" "${retry_times}" "${commit_cmd}" "${historical_ver}"
        fi
    done
    rm -f pmc_info.txt
}

function getAllDisk()
{
    sn_model_dict=$1
    SMARTCTL_TOOL=${SMARTCTL_PATH}
    chmod 755 ${SMARTCTL_TOOL}
    if [ "${sn_model_dict[*]}" != "" ] && [ "${!sn_model_dict[*]}" != "" ];then
        return
    fi
    lsscsi -g | grep "Smart Adapter" | awk '{print $NF}' > raid_letter.tmp
    while read line
    do
        for((i=0;i<65;i++))
        do
            # SATA盘过滤字段为Device Model和Serial Number,SAS是Product和Serial number
            # 加冒号是防止过滤Device Model的时候，过滤出Vendor Product Id的情况           
            model=`${SMARTCTL_TOOL} -a -d cciss,${i} ${line} | grep -E "Device Model:|Product:" | awk -F ':' '{print $2}' |sed -e 's/^[ \t]*//g'`
            sn=`${SMARTCTL_TOOL} -a -d cciss,${i} ${line} | grep -E "Serial Number:|Serial number:" | awk -F ':' '{print $2}' |sed -e 's/^[ \t]*//g'`
            if [ "${line}" != "" ] && [ "${model}" != "" ] && [ "${sn}" != "" ];then
                model=$(echo "${model}" | sed -e 's/[ \t]*//g')
                sn_model_dict["${sn}"]="${model}"
            fi
        done
    done < raid_letter.tmp
}

function main()
{
    local harddisk_pmc_cfg=$1
    local upgrade_flag=""
    if [ $# -eq 1 ];then
        upgrade_flag="true"
    elif [ $# -gt 1 ] && [ $2 == "list" ];then
        upgrade_flag="false"
    else
        echo "para error return now"
        exit 1
    fi
    
    declare -a pmc_disk_seq
    dosToUnix $harddisk_pmc_cfg
    declare -A pmc_cfg_dict

    while read LINE
    do
        line=$LINE
        if [[ $LINE == \#* ]];then
            continue
        fi
        OLD_IFS="$IFS"
        IFS=","
        configInfo=($LINE)
        IFS="$OLD_IFS"
        model=$(echo ${configInfo[0]})
        new_version=$(echo ${configInfo[1]})
        fwfile=$(echo ${configInfo[2]})
        retry_times=$(echo ${configInfo[3]})
        upgrade_cmd=$(echo ${configInfo[4]})
        historical_version=$(echo ${configInfo[5]})
        if [[ "${historical_version}" != "N/A" ]];then
            model="${model}|${historical_version}"
        fi
        pmc_disk_seq+=("${model}")
        pmc_cfg_dict["${model}"]="${new_version},${fwfile},${retry_times},${upgrade_cmd},${historical_version}"
    done < ${harddisk_pmc_cfg}
    currsegment=0
    totalnum=${#pmc_disk_seq[*]}
    totalsegment=`expr $totalnum \* 2 `
    
    if [ -d ${PMC_NEW_TOOL_PATH} ];then
        PMC_TOOL_NAME=`ls ${PMC_NEW_TOOL_PATH}`
        PMC_TOOL=${PMC_NEW_TOOL_PATH}"/"${PMC_TOOL_NAME}
    else
        PMC_TOOL=${PMC_OLD_TOOL_PATH}
    fi
    
    chmod 755 ${PMC_TOOL}
    for disk_model in ${pmc_disk_seq[*]}
    do
        local ctrlModel=$(echo ${disk_model} | awk -F "|" '{print $1}')
        if [ ${upgrade_flag} == "true" ];then
            let currsegment=$currsegment+1
            progressinfo=`echo ${ctrlModel} default updating`
            updateDiskPmcFwMain "${ctrlModel}" "${pmc_cfg_dict["${disk_model}"]}" "${PMC_TOOL}"
            let currsegment=$currsegment+1
            progressinfo=`echo ${ctrlModel} default update finished`
        else
           updateFwPmcList "${ctrlModel}" "${pmc_cfg_dict["${disk_model}"]}" "${PMC_TOOL}"
        fi
    done

}

main $@