#!/bin/bash

#升级fw工具
INTEL_UPDATE_FW_TOOL_NAME="eeupdate64e"
INTEL_NVM_UPDATE_FW_TOOL_NAME="nvmupdate64e"
NIC_PXE_SET_CHECK_TOOL_NAME="bootutil64e"
BOOTIMG_NAME="BootIMG.FLB"


##===================================#
# 功能： INTEL卡信息收集公共函数
# 入参：配置文件 各列
#    $1  cardModel      : 卡型号
#    $2  result_file    : 结果文件;
##===================================#
function get_intel_info()
{
    local cardModel=$1
    local result_file=$2
    declare -A map_id_model
    declare -A map_model_fw
    while read LINE
    do
       if [[ $LINE == \#* ]];then
           continue
       fi
       OLD_IFS="$IFS"
       #由于配置文件fw.conf改为了fw.csv,此处'|'分隔符变更为','
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS"
       map_model_fw["${configInfo[1]}"]="${configInfo[2]}"
       map_id_model["${configInfo[0]}"]="${configInfo[1]}"
    done < ${INTEL_INFO_MAP}
    for key in ${!map_id_model[*]}
    do
        if [ ${map_id_model[$key]} = $cardModel ];then
            vender_id=$(echo $key | awk -F_ '{print$1}')
            sub_vender_id=$(echo $key | awk -F_ '{print$2}')
            for NicId in `$INTEL_UPDATE_FW_TOOL | grep "00  00   ${vender_id}" | awk '{print $1}'`
            do
                subPciInfo=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /PCIINFO | grep "${vender_id}" |grep "${sub_vender_id}" | wc -l)
                if [ $subPciInfo -ne 0 ];then
                    pci_bus_16=`$INTEL_UPDATE_FW_TOOL /NIC=$NicId /PCIINFO | grep "${vender_id}" |grep "${sub_vender_id}"| awk '{print $2}'`
                    pci_bus_10=$((16#${pci_bus_16}))
                    echo "$NicId ${map_id_model[$key]} ${map_model_fw[${cardModel}]} ${pci_bus_10}" >>$result_file
                fi
            done
        fi
    done
}


##===================================#
# 功能： INTEL信息查询
# 入参：配置文件 各列
#    $1  model    : 网卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息
##===================================#
function listIntelDriveDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "default" ];then
        printf "%-10s %-10s %-12s %-10s %-11s %-8s %-3s\n"   Device  Verdor NicId Model FwType FwVer >>intel.list
    fi
    fwVerLen=$(echo $newVer | wc -L)
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do
        local intel_card_type="unknown"
        intel_card_type=$(echo $myline |awk '{print$2}')
        if [ ${intel_card_type} = ${ctrlModel} ];then
            NicId=$(echo $myline | awk -F ' ' '{print $1}')
            fw_type=$(echo $myline |awk '{print $3}')
            if [ ${fwType} = "default" ];then
                case "$fw_type" in
                "Firmware")
                    local CtrlVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep "Firmware Version" |awk '{print $3}'|awk -F ':' '{print $2}'| sed -e 's/^[ \t]*//g')
                    CtrlVerLen=$(echo $CtrlVer | wc -L)
                    if [ $CtrlVerLen != $fwVerLen ];then
                        local EtrackVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO | grep 'EtrackID' | awk '{print $2}' | awk '$1=$1')
                        CtrlVer=$CtrlVer'_'$EtrackVer
                    fi
                    ;;
                "NVM")
                    local NvmVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep 'NVM Version'|awk '{print $3}' | sed -e 's/^[ \t]*//g')
                    local CtrlVer=$NvmVer
                    ;;
                "NVM_EtrackID")
                    local NvmVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep 'NVM Version'|awk '{print $3}' | sed -e 's/^[ \t]*//g')
                    local EtrackVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO | grep 'EtrackID' | awk '{print $2}' | sed -e 's/^[ \t]*//g')
                    local CtrlVer=$NvmVer'_'$EtrackVer
                    ;;
                esac
            fi
            if [ ${CtrlVer} = ${newVer} ];then
                printf "\e[37m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "nic" "intel" ${NicId} ${ctrlModel} ${fwType} "${CtrlVer}"  >>intel.list
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "nic" "intel" ${NicId} ${ctrlModel} ${fwType} "${CtrlVer}"  >>intel.list
            fi
        else
            continue
        fi
    done < $infoFile
    IFS="$OLD_IFS"
    #echo -e ""     >>intel.list
}

##===================================#
# 功能： 获取PMC卡的数量
# 入参：$1 卡类型
#       $2 intel卡信息文件
# 输出：intel_card_num.tmp
##===================================#
function get_intel_num()
{
    local ctrlModel=$1
    local intel_info_file=$2
    local total_num=0
    while read myline
    do
        local cardtype=$(echo $myline|awk '{print$2}')
        if [ ${cardtype} = ${ctrlModel} ];then
            let total_num=total_num+1
        fi
    done <${intel_info_file}
    echo ${total_num} > "intel_card_num.tmp"
}

##===================================#
# 功能： INTEL固件信息查询
# 入参：配置文件 各列
#     $1  model ：控制器类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息。
##===================================#
function listIntelDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3
    
    rm -f "IntelInfo.tmp"
    if [ ! -f "IntelInfo.tmp" ];then
        echo "scaning the intel nic card in server......."
        get_intel_info "$ctrlModel" "IntelInfo.tmp"
        if [ ! -f "IntelInfo.tmp" ];then
            echo "no support intel nic card" >IntelInfo.tmp
        fi
    fi
    get_intel_num "${ctrlModel}" "IntelInfo.tmp"
    local TotalNum=$(cat "intel_card_num.tmp")
    rm -rf "intel_card_num.tmp"
    if [ $fwType = "default" ];then
        echo -e "====================intel nic card model(${ctrlModel}) info===================== " >>intel.list
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>intel.list
    fi
    if [ ${TotalNum} -ne 0 ]
    then
        listIntelDriveDetails "${ctrlModel}" "IntelInfo.tmp" "${newVer}" "$fwType"
    fi
}

##===================================#
# 功能： INTEL 网卡的固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
#       $3 : 待升级intel nic卡个数
##===================================#
function intelUpdateCheck()
{
    local intelresult=$1
    local fwType=$2
    local intelNum=$3
    local ctrlModel=$4
    updateNum=$(cat $intelresult | wc -l)
    
    if [ $updateNum -eq 0 ];then
        return 0
    fi
    fwFailed=$(cat $intelresult | grep ${ctrlModel} | grep "default update failed" | wc -l)
    fwSucced=$(cat $intelresult | grep ${ctrlModel} | grep "default update OK" | wc -l)
    pxeFailed=$(cat $intelresult | grep ${ctrlModel} | grep "pxe enable failed" | wc -l)
    pxeSucess=$(cat $intelresult | grep ${ctrlModel} | grep "pxe enable OK" | wc -l)
    if [ $fwType = "default" ];then
        if [ $fwFailed -eq 0 ] && [ $pxeFailed -eq 0 ];then
            greenFont "total intel card($ctrlModel) num:$intelNum,fw update succeed num:$fwSucced,pxe enabled succeed num:$pxeSucess,fw update failed num:$fwFailed,pxe enabled failed num:$pxeFailed" | tee -a intel.result
        else
            redFont "total intel card($ctrlModel) num:$intelNum,fw update succeed num:$fwSucced,pxe enable succeed num:$pxeSucess,fw update failed num:$fwFailed,pxe enable failed num:$pxeFailed,please Check!" | tee -a intel.result
            while read myline
            do
                defaultinfo=$(echo $myline | grep default | wc -l)
                if [ defaultinfo != 0 ];then               
                   redFont "$myline" | tee -a intel.result
                fi
            done <$intelresult
        fi
    fi
}

##===================================#
# 功能： INTEL 网卡的固件升级
# 入参:
#       $1 : Intel model:网卡芯片类型
#       $2 : fw_file：待升级固件
#       $3 : newVersion：待升级固件版本信息
#       $4 : fwType：待升级固件类型
##===================================#
function updateIntelFW()
{
    local ctrlModel=$1
    local fwFile=$2
    local newVersion=$3
    local fwType=$4
    
    rm -f "updateIntelFW.tmp"
    if [ ! -f "updateIntelFW.tmp" ];then
        echo "scaning the intel nic card  for update in server......." | tee -a ${UPDATE_LOG}
        get_intel_info "$ctrlModel" "updateIntelFW.tmp"
        if [ ! -f "updateIntelFW.tmp" ];then
            echo "no support intel nic card" >updateIntelFW.tmp
        fi
    fi
    get_intel_num "${ctrlModel}" "updateIntelFW.tmp"
    local IntelCardNum=$(cat "intel_card_num.tmp")
    rm -rf "intel_card_num.tmp"
    if [ ${IntelCardNum} -eq 0 ]
    then
        echo -e "Total intel nic card(${ctrlModel}) num: 0,success num : 0" |tee -a intel.result
        greenFont "no intel nic card (${ctrlModel}) in this server,no need to update" |tee -a intel.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no card"
        return 0
    fi
    newVersionLen=$(echo $newVersion | wc -L)
    while read myline
    do
        local intel_card_model="unknown"
        intel_card_model=$(echo $myline | awk '{print$2}')
        if [ ${intel_card_model} = ${ctrlModel} ];then
            starttime=`date +'%Y-%m-%d %H:%M:%S'`
            start_seconds=$(date --date="$starttime" +%s)
            NicId=$(echo $myline | awk -F ' ' '{print $1}')
            fw_type=$(echo $myline |awk '{print $3}')
            pci_bus=$(echo $myline | awk '{print $4}')
            if [ ${fwType} = "default" ];then
                case "$fw_type" in
                "Firmware")
                    local CtrlVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep "Firmware Version" |awk '{print $3}'|awk -F ':' '{print $2}'| sed -e 's/^[ \t]*//g')
                    CtrlVerLen=$(echo $CtrlVer | wc -L)
                    if [ $CtrlVerLen != $newVersionLen ];then
                        local EtrackVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO | grep 'EtrackID' | awk '{print $2}' | awk '$1=$1')
                        CtrlVer=$CtrlVer'_'$EtrackVer
                    fi
                    ;;
                "NVM")
                    local NvmVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep 'NVM Version'|awk '{print $3}' | sed -e 's/^[ \t]*//g')
                    local CtrlVer=$NvmVer
                    ;;                
                "NVM_EtrackID")
                    local NvmVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep 'NVM Version'|awk '{print $3}' | sed -e 's/^[ \t]*//g')
                    local EtrackVer=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO | grep 'EtrackID' | awk '{print $2}' | sed -e 's/^[ \t]*//g')
                    local CtrlVer=$NvmVer'_'$EtrackVer
                    ;;
                esac
            else
                redFont "intel nic card(${ctrlModel}) $NicId fwtype is error " | tee -a intel.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $NicId $fwType "failed" "--" $newVersion $updatetime
                continue
            fi
            if [ ${CtrlVer} = ${newVersion} ];then 
                greenFont "intel nic card(${ctrlModel}) $NicId $fwType is new version(${newVersion}) in this server,no need to update " |tee -a intel.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $NicId $fwType "success" $CtrlVer $newVersion $updatetime
            else
                if [ ${fwType} = "default" ];then
                    if [[ "${ctrlModel}" =~ "E810" ]];then
                        insmodICEDriver "${ctrlModel}" "${fwType}" "${CtrlVer}"
                        nvmcfg_path=`dirname ${fwFile}`
                        cfg_path=`find $nvmcfg_path -name '*.cfg'`
                        cfg_name=`basename $cfg_path`
                        pci_segment=`$INTEL_NVM_UPDATE_FW_TOOL -i -l | grep "${pci_bus}:00:00" | sed -n 1p | awk -F ':' '{print $1}' | sed -e 's/\[//g' `
                        chmod +x ${nvmcfg_path}"/"${cfg_name}
                        `$INTEL_NVM_UPDATE_FW_TOOL -u -l -location ${pci_segment}:${pci_bus} -a ${nvmcfg_path}"/" -b -c ${cfg_name} > intel_E810.tmp`
                        updatestatus=$(cat intel_E810.tmp | grep "Device update successful" | wc -l)
                        # ;;
                    # *)
                    else
                        update_result=`$INTEL_UPDATE_FW_TOOL /NIC=$NicId /D $fwFile`
                        updatestatus=`echo ${update_result} |grep successfully |wc -l`
                        echo "${ctrlModel} nic:${NicId} upgrade result:${update_result}" >> $UPDATE_LOG
                    fi
                    endtime=`date +'%Y-%m-%d %H:%M:%S'`
                    end_seconds=$(date --date="$endtime" +%s)
                    updatetime=$((end_seconds-start_seconds))
                    if [ 1 -eq $updatestatus ];then
                        echo "intel nic card($ctrlModel) $NicId $fwType update OK" >>intelresult.tmp
                        updateResult $ctrlModel $NicId $fwType "success" $CtrlVer $newVersion $updatetime
                    else
                        echo "intel nic card($ctrlModel) $NicId $fwType update failed,please Check!" >>intelresult.tmp
                        updateResult $ctrlModel $NicId $fwType "failed" $CtrlVer $newVersion $updatetime
                    fi
                fi
            fi
            macAddr=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /ADAPTERINFO |grep 'MAC Address'|awk '{print $3}'|sed 's/[-]//g')
            busId16=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /PCIINFO |grep $macAddr|awk '{print $2}'|sed 's/[-]//g')
            busId=$((16#${busId16}))
            deviceId16=$($INTEL_UPDATE_FW_TOOL /NIC=$NicId /PCIINFO |grep $macAddr|awk '{print $3}'|sed 's/[-]//g')
            deviceId=$(echo $((16#${deviceId16}))| awk '{printf("%02d\n",$0)}')
            starttime=`date +'%Y-%m-%d %H:%M:%S'`
            start_seconds=$(date --date="$starttime" +%s)
            for port in `$NIC_PXE_SET_CHECK_TOOL | grep ${busId}:${deviceId} | grep -v 'PXE' | grep -v 'WARNING:' | awk '{print $1}'`
            do
                # $NIC_PXE_SET_CHECK_TOOL -all -FE
                $NIC_PXE_SET_CHECK_TOOL -nic=$port -FLASHENABLE  >/dev/null 2>&1
                $NIC_PXE_SET_CHECK_TOOL -nic=$port -up=pxe+efi -file=$BOOTIMG >/dev/null 2>&1<<- EOF
				N
				Y
				Y
				EOF
            done
            endtime=`date +'%Y-%m-%d %H:%M:%S'`
            end_seconds=$(date --date="$endtime" +%s)
            updatetime=$((end_seconds-start_seconds))
            portNum=$($NIC_PXE_SET_CHECK_TOOL | grep ${busId}:${deviceId} |grep -v 'WARNING:'| wc -l)
            portPxeNum=$($NIC_PXE_SET_CHECK_TOOL | grep ${busId}:${deviceId} | grep 'PXE' |grep -v 'WARNING:'| wc -l)
            if [ ${portNum} -ne ${portPxeNum} ];then
                pxe_enable_flag=$($NIC_PXE_SET_CHECK_TOOL | grep -c 'cannot be modified')
                if [ ${pxe_enable_flag} -ne 0 ];then
                    echo "intel nic card($ctrlModel) $NicId pxe enable failed,need to reboot host and update again to enable pxe" >>intelresult.tmp   
                    updateResult $ctrlModel $NicId "pxe" "failed" $CtrlVer $newVersion $updatetime "need to reboot host and update again to enable pxe"
                else
                    echo "intel nic card($ctrlModel) $NicId pxe enable failed,please Check!" >>intelresult.tmp
                    updateResult $ctrlModel $NicId "pxe" "failed" $CtrlVer $newVersion $updatetime
                fi
            else
                echo "intel nic card($ctrlModel) $NicId pxe enable OK" >>intelresult.tmp
                updateResult $ctrlModel $NicId "pxe" "success" $CtrlVer $newVersion $updatetime
            fi
        else
            continue
        fi
    done < updateIntelFW.tmp
    if [ -f "intelresult.tmp" ];then
        intelUpdateCheck "intelresult.tmp" "$fwType" "$IntelCardNum" "$ctrlModel"
        rm -rf "intelresult.tmp"
    fi

}

##===================================#
# 功能：加载ice驱动
# 入参：无
##===================================#
function insmodICEDriver()
{
    local ctrlModel=$1
    local fwType=$2
    local fwVer=$3
    DRIVE_ICE_MODULES_PATH="/usr/lib/modules/3.10.0-1062.el7.x86_64/updates/drivers/net/ethernet/intel/ice/ice.ko"
    DRIVE_ICE_FIRMWARE_PATH="/usr/lib/firmware/updates/intel/ice/ddp"
    
    if [ ! -f "${DRIVE_ICE_FIRMWARE_PATH}/ice.pkg" ]
    then
        ln -s ${DRIVE_ICE_FIRMWARE_PATH}"/ice-1.3.26.0.pkg" ${DRIVE_ICE_FIRMWARE_PATH}"/ice.pkg"
    fi

    modprobe -r ice
    depmod -a
    modprobe -v ice

    driverResultCheck=$(lsmod | grep "ice" | wc -l)
    if [ ${driverResultCheck} -gt 1 ]
    then
        greenFont "Load ice drive success"
    else
        redFont "Load ice drive failed, please Check!"
        echo "intel nic card($ctrlModel) $fwType update failed, please Check" >>intelresult.tmp
        updateResult "$ctrlModel" "--" "$fwType" "failed" "$fwVer" "--" "0" "Load ice drive failed"
        return 0
    fi
}

##===================================#
# 功能： INTEL的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件
##===================================#
function intelMain()
{

    local deviceType=$1
    local vendorType=$2
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"  
    
    INTEL_UPDATE_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${INTEL_UPDATE_FW_TOOL_NAME}
    INTEL_NVM_UPDATE_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${INTEL_NVM_UPDATE_FW_TOOL_NAME}
    NIC_PXE_SET_CHECK_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${NIC_PXE_SET_CHECK_TOOL_NAME}
    BOOTIMG=${SCRIPT_PATH}"/"${fwToolsDir}"/"${BOOTIMG_NAME}

    chmod +x ${INTEL_NVM_UPDATE_FW_TOOL}
    chmod +x ${fullPathFw}

    if [ ! -f "${INTEL_UPDATE_FW_TOOL}" -o ! -f "${NIC_PXE_SET_CHECK_TOOL}" -o ! -f "${BOOTIMG}" -o ! -f "${fullPathFw}" -o ! -f "${INTEL_NVM_UPDATE_FW_TOOL}" ]
    then
        redFont " ${INTEL_UPDATE_FW_TOOL} or ${NIC_PXE_SET_CHECK_TOOL} or ${BOOTIMG} or ${fullPathFw} dont exist"
        echo "intel nic card($contrlModel) $fwType update failed, please Check" >>intelresult.tmp
        updateResult "$contrlModel" "--" "$fwType" "failed" "$fwVer" "--" "0" "UpdateTool or firware file dont exist"
        return 0
    fi
	
    dosToUnix ${INTEL_INFO_MAP}
    #非配置文件中的参数处理    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then     
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listIntelDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    declare -A map
    while read LINE
    do
       if [[ $LINE == \#* ]];then
           continue
       fi
       OLD_IFS="$IFS"
       #由于配置文件fw.conf改为了fw.csv,此处'|'分隔符变更为','
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS"   
       map["${configInfo[1]}"]="${configInfo[2]}"     
    done < ${INTEL_INFO_MAP}
    #固件升级
    if [ ! -z ${map["${contrlModel}"]} ];then 
        if [ $deviceType = "nic" -a $vendorType = "INTEL" ];then
            updateIntelFW "${contrlModel}" "${fullPathFw}" "${fwVer}" "${fwType}"
        else
            echo "don't support $deviceType or $vendorType"
        fi
    else
        echo "don't support intel nic card model :${contrlModel}" 
    fi
}

intelMain $@