#!/bin/bash

#升级fw工具
LSI_UPDATE_FW_TOOL_NAME="storcli-linux"


#定义LSI字典
declare -A LSI_dic
LSI_dic=(["0x1000_0x5D_0x1000_0x9361"]="9361-8i" ["0x1000_0x5D_0x1000_0x9A61"]="9361-8i" ["0x1000_0xCE_0x1000_0x9371"]="9361-16i" ["0x1000_0xCE_0x1000_0x9A71"]="9361-16i")
#LSI_dic+=(["0x1000_0x5F_0x1000_0x9341"]="9341-8i" ["0x1000_0x16_0x1000_0x9461"]="9460-8i" ["0x1000_0x16_0x1000_0x9A61"]="9460-8i" ["0x1000_0x14_0x1000_0x9460"]="9460-16i" ["0x1000_0x14_0x1000_0x9A60"]="9460-16i")
#LSI_dic+=(["0x1000_0x17_0x1000_0x9440"]="9440-8i" ["0x1000_0x10E2_0x1000_0x4010"]="9560-8i" ["0x1000_0x10E2_0x1000_0x4000"]="9560-16i")

##===================================#
# 功能： LSI信息查询
# 入参：配置文件 各列
#    $1  model    : 控制卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息
##===================================#
function listLsiDriveDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "fw" ];then
        printf "%-10s %-10s %-12s %-10s %-11s %-8s %-3s\n"   Device  Verdor CtrlId Model FwType FwVer >>lsi.list
    fi
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do
        ctrlModelNum=$(echo $myline |grep $ctrlModel |wc -l)
        if [ ${ctrlModelNum} -ne 0 ];then
            CtrlId=$(echo $myline | awk -F ' ' '{print $1}')
            if [ ${fwType} = "fw" ];then
                local FwVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'FW Version' |awk -F '=' '{print $2}'| sed -e 's/^[ \t]*//g')
                NvdataNum=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'NVDATA Version' |wc -l)
                if [ ${NvdataNum} -ne 0 ];then
                # if [ ${ctrlModel} = '9305-16i' -o ${ctrlModel} = '9400-8i' -o ${ctrlModel} = '9400-16i' -o ${ctrlModel} = 'SDLSA(SAS3008)' ];then
                    local NvdataVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'NVDATA Version' |awk -F '=' '{print $2}'| sed -e 's/^[ \t]*//g')
                    local CtrlVer=$FwVer'_'$NvdataVer
                else
                    local CtrlVer=$FwVer
                fi
            elif [ ${fwType} = "legacy" ];then
                local CtrlVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'BIOS Version' |awk -F '=' '{print $2}'| awk -F '_' '{print $1}'|sed -e 's/^[ \t]*//g')
            elif [ ${fwType} = "uefi" ];then
                local CtrlVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'BIOS Version' |awk -F '=' '{print $2}'| awk -F '_' '{print $2}'|sed -e 's/^[ \t]*//g')
            elif [ ${fwType} = "cpld" ];then
                local CtrlVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show all |grep 'CPLD Version' |awk -F '=' '{print $2}'|sed -e 's/^[ \t]*//g')
            fi
            if [ -z $CtrlVer ];then
                CtrlVer='0.0.0.0'
            fi
            if [ ${CtrlVer} = ${newVer} ];then
                printf "\e[37m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "raid" "lsi" ${CtrlId} ${ctrlModel} ${fwType} "${CtrlVer}"  >>lsi.list
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "raid" "lsi" ${CtrlId} ${ctrlModel} ${fwType} "${CtrlVer}"  >>lsi.list
            fi
        else
            continue
        fi
    done < $infoFile
    IFS="$OLD_IFS"
    #echo -e ""     >>lsi.list
}

##===================================#
# 功能： LSI固件信息查询
# 入参：配置文件 各列
#     $1  model ：控制器类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息。
##===================================#
function listLsiDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3

    if [ ! -f "LsiInfo.tmp" ];then
        echo "scaning the lsi raid card in server......."
        # serverS1008=$(ipmitool fru print 0|grep 'Product Name'|grep 'SCUH'|wc -l)
        serverS1008=$(dmidecode -t baseboard|grep 'Product Name'|grep 'S1008'|wc -l)
        if [ ${serverS1008} -ne 1 ];then
            # 9341/9361/9460/9440/9400/9305/9500等都含有SAS字段，9560没有SAS字段，只有MegaRAID字段，增加对9560的兼容
            $LSI_UPDATE_FW_TOOL show | grep -Ei 'SAS|MegaRAID|JBOD' >LsiInfo.tmp
        else
            s1008SAS3008=$($LSI_UPDATE_FW_TOOL show |grep SAS3008|wc -l)
            if [ $s1008SAS3008 -eq 4 ];then
                biosCtrlId=$($LSI_UPDATE_FW_TOOL show |grep 'SAS3008'|grep '00:01:00:00'|awk '{print $1}')
                for CtrlId in `$LSI_UPDATE_FW_TOOL show |grep 'SAS3008'|awk '{print $1}'`
                do
                    if [ ${biosCtrlId} -eq ${CtrlId} ];then
                        ctrlName="S1008(SAS3008)-1"
                    else
                        ctrlName="S1008(SAS3008)-2"
                    fi
                    echo  $CtrlId  $ctrlName                      >>LsiInfo.tmp
                done
            else
                redFont "The SAS3008 chip number in S1008 server is not equal to 4" |tee -a LsiInfo.tmp
            fi
        fi
        if [ ! -f "LsiInfo.tmp" ];then
            echo "no support lsi raid card" >LsiInfo.tmp
        fi
    fi

    local jbod_model_exist=$(cat LsiInfo.tmp |grep -c "JBOD")
    if [ ${jbod_model_exist} -ne 0 ];then
        get_jbod_card_model "LsiInfo.tmp"
    fi
    local TotalNum=`cat LsiInfo.tmp | grep -i $ctrlModel | wc -l`
    if [ $fwType = "fw" ];then
        echo -e "====================lsi raid card model(${ctrlModel}) info===================== " >>lsi.list
                                                
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>lsi.list                    
    fi
    if [ ${TotalNum} -ne 0 ]
    then 
        listLsiDriveDetails "${ctrlModel}" "LsiInfo.tmp" "${newVer}" "$fwType"
    fi
}

##===================================#
# 功能： LSI 控制卡的固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
#       $3 : 待升级lsi raid卡个数
##===================================#
function lsiUpdateCheck()
{
    local lsiresult=$1
    local fwType=$2
    local lsiNum=$3
    local ctrlModel=$4
    updateNum=$(cat $lsiresult | wc -l)
    if [ $updateNum -eq 0 ];then
        return 0
    fi
    fwFailed=$(cat $lsiresult | grep ${ctrlModel} | grep "fw update failed" | wc -l)
    fwSucced=$(cat $lsiresult | grep ${ctrlModel} | grep "fw update OK" | wc -l)
    legacyFailed=$(cat $lsiresult | grep ${ctrlModel} | grep "legacy update failed" | wc -l)
    legacySucced=$(cat $lsiresult | grep ${ctrlModel} | grep "legacy update OK" | wc -l)
    uefiFailed=$(cat $lsiresult | grep ${ctrlModel} | grep "uefi update failed" | wc -l)
    uefiSucced=$(cat $lsiresult | grep ${ctrlModel} | grep "uefi update OK" | wc -l)
    cpldFailed=$(cat $lsiresult | grep ${ctrlModel} | grep "cpld update failed" | wc -l)
    cpldSucced=$(cat $lsiresult | grep ${ctrlModel} | grep "cpld update OK" | wc -l)
    if [ $fwType = "fw" ];then
        if [ $fwFailed -eq 0 ];then
            greenFont "total lsi card($ctrlModel) num:$lsiNum,fw succeed num:$fwSucced,fw failed num:$fwFailed" | tee -a lsi.result
        else
            redFont "total lsi card($ctrlModel) num:$lsiNum,fw succeed num:$fwSucced,fw failed num:$fwFailed,please Check!" | tee -a lsi.result
            while read myline
            do
                fwinfo=$(echo $myline | grep fw | wc -l)
                if [ fwinfo != 0 ];then               
                   redFont "$myline" | tee -a lsi.result
                fi
            done <$lsiresult
        fi
    elif [ $fwType = "legacy" ];then
        if [ $legacyFailed -eq 0 ];then
            greenFont "total lsi card($ctrlModel) num:$lsiNum,legacy succeed num:$legacySucced,legacy failed num:$legacyFailed" | tee -a lsi.result
        else
            redFont "total lsi card($ctrlModel) num:$lsiNum,legacy succeed num:$legacySucced,legacy failed num:$legacyFailed,please Check!" | tee -a lsi.result
            while read myline
            do
                legacyinfo=$(echo $myline | grep legacy | wc -l)
                if [ legacyinfo != 0 ];then               
                   redFont "$myline" | tee -a lsi.result
                fi
            done <$lsiresult
        fi
    elif [ $fwType = "uefi" ];then
        if [ $uefiFailed -eq 0 ];then
            greenFont "total lsi card($ctrlModel) num:$lsiNum,uefi succeed num:$uefiSucced,uefi failed num:$uefiFailed" | tee -a lsi.result
        else
            redFont "total lsi card($ctrlModel) num:$lsiNum,uefi succeed num;$uefiSucced,uefi failed num:$uefiFailed,please Check!" | tee -a lsi.result
            while read myline
            do
                uefiinfo=$(echo $myline | grep uefi | wc -l)
                if [ uefiinfo != 0 ];then               
                   redFont "$myline" | tee -a lsi.result
                fi
            done <$lsiresult
        fi
    elif [ $fwType = "cpld" ];then
        if [ $cpldFailed -eq 0 ];then
            greenFont "total lsi card($ctrlModel) num:$lsiNum,cpld succeed num:$cpldSucced,cpld failed num:$cpldFailed" | tee -a lsi.result
        else
            redFont "total lsi card($ctrlModel) num:$lsiNum,cpld succeed num:$cpldSucced,cpld failed num:$cpldFailed,please Check!" | tee -a lsi.result
            while read myline
            do
                cpldinfo=$(echo $myline | grep cpld | wc -l)
                if [ cpldinfo != 0 ];then               
                   redFont "$myline" | tee -a lsi.result
                fi
            done <$lsiresult
        fi
    fi
}


##========================================#
# 功能： LSI卡JBOD模式后,卡的具体型号的获取
# 根据Vendor id、Device id、SubVendor id、
# SubDevice id 唯一确定卡的型号
# 入参:
#       $1 : 原始的卡信息文件
##========================================#

function get_jbod_card_model()
{
    local card_info_file=$1
    cp "${card_info_file}" "${card_info_file}.tmp"
    rm -f ${card_info_file}
    while read line
    do
        local jbod_flag=$(echo ${line} |grep -c "JBOD")
        if [ ${jbod_flag} -ne 0 ];then
            local card_id=$(echo $line | awk -F ' ' '{print $1}')
            local Vendor_id=$($LSI_UPDATE_FW_TOOL /c$card_id show |grep "Vendor Id" |grep -v "SubVendor Id" |awk -F= '{print $NF}'|sed 's/[ /t]*//g')
            local Device_id=$($LSI_UPDATE_FW_TOOL /c$card_id show |grep "Device Id" |grep -v "SubDevice Id" |awk -F= '{print $NF}'|sed 's/[ /t]*//g')
            local SubVendor_id=$($LSI_UPDATE_FW_TOOL /c$card_id show |grep "SubVendor Id" |awk -F= '{print $NF}'|sed 's/[ /t]*//g')
            local SubDevice_id=$($LSI_UPDATE_FW_TOOL /c$card_id show |grep "SubDevice Id" |awk -F= '{print $NF}'|sed 's/[ /t]*//g')
            local lsi_dic_key="${Vendor_id}_${Device_id}_${SubVendor_id}_${SubDevice_id}"
            local lsi_model=${LSI_dic[${lsi_dic_key}]}
            if [ ! -z ${lsi_model} ];then
                model_tmp=${lsi_model}
            else
                model_tmp="unknown"
            fi
            echo  $card_id  $model_tmp                      >> "${card_info_file}"
        else
            echo $line >> "${card_info_file}"
        fi
    done < "${card_info_file}.tmp"
    rm -f "${card_info_file}.tmp"
}


##===================================#
# 功能： LSI 控制卡的固件升级
# 入参:
#       $1 : Raid model:控制卡芯片类型
#       $2 : fw_file：待升级固件
#       $3 : newVersion：待升级固件版本信息
#       $4 : fwType：待升级固件类型
##===================================#
function updateLsiFW()
{
    local ctrlModel=$1
    local fwFile=$2
    local newVersion=$3
    local fwType=$4

    if [ ! -f "updateLsiFW.tmp" ];then
        echo "scaning the lsi raid card for update in server......." | tee -a ${UPDATE_LOG}
        # serverS1008=$(ipmitool fru print 0|grep 'Product Name'|grep 'SCUH'|wc -l)
        serverS1008=$(dmidecode -t baseboard|grep 'Product Name'|grep 'S1008'|wc -l)
        if [ ${serverS1008} -ne 1 ];then
            # 9341/9361/9460/9440/9400/9305/9500等都含有SAS字段，9560没有SAS字段，只有MegaRAID字段，增加对9560的兼容
            $LSI_UPDATE_FW_TOOL show | grep -Ei 'SAS|MegaRAID|JBOD' >updateLsiFW.tmp
        else
            s1008SAS3008=$($LSI_UPDATE_FW_TOOL show |grep SAS3008|wc -l)
            if [ $s1008SAS3008 -eq 4 ];then
                biosCtrlId=$($LSI_UPDATE_FW_TOOL show |grep 'SAS3008'|grep '00:01:00:00'|awk '{print $1}')
                for CtrlId in `$LSI_UPDATE_FW_TOOL show |grep 'SAS3008'|awk '{print $1}'`
                do
                    if [ ${biosCtrlId} -eq ${CtrlId} ];then
                        ctrlName="S1008(SAS3008)-1"
                    else
                        ctrlName="S1008(SAS3008)-2"
                    fi
                    echo  $CtrlId  $ctrlName                      >>updateLsiFW.tmp
                done
            else
                redFont "The SAS3008 chip number in S1008 server is not equal to 4" |tee -a updateLsiFW.tmp
            fi
        fi
        if [ ! -f "updateLsiFW.tmp" ];then
            echo "no support lsi raid card" >updateLsiFW.tmp
        fi
    fi
    
    local jbod_model_exist=$(cat updateLsiFW.tmp |grep -c "JBOD")
    if [ ${jbod_model_exist} -ne 0 ];then
        get_jbod_card_model "updateLsiFW.tmp"
    fi
    
    local LsiContrlNum=$(cat updateLsiFW.tmp  | grep -i $ctrlModel | wc -l)

    if [ ${LsiContrlNum} -eq 0 ]
    then 
        echo -e "Total lsi raid card(${ctrlModel}) num: 0,success num : 0" |tee -a lsi.result
        greenFont "no lsi raid card (${ctrlModel}) in this server,no need to update" |tee -a lsi.result
        updateResult $ctrlModel "--" "fw" "success" "--" "--" "0" "no card"
        return 0
    fi
    while read myline
    do
        ctrlModelNum=$(echo $myline |grep $ctrlModel |wc -l)
        if [ ${ctrlModelNum} -ne 0 ];then
            starttime=`date +'%Y-%m-%d %H:%M:%S'`
            start_seconds=$(date --date="$starttime" +%s)
            CtrlId=$(echo $myline | awk -F ' ' '{print $1}')
            if [ ${fwType} = "fw" ];then
                local FwVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'FW Version' |awk -F '=' '{print $2}'| sed -e 's/^[ \t]*//g')
                NvdataNum=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'NVDATA Version' |wc -l)
                if [ ${NvdataNum} -ne 0 ];then
                # if [ ${ctrlModel} = '9305-16i' -o ${ctrlModel} = '9400-8i' -o ${ctrlModel} = '9400-16i' -o ${ctrlModel} = 'SDLSA(SAS3008)' ];then
                    local NvdataVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'NVDATA Version' |awk -F '=' '{print $2}'| sed -e 's/^[ \t]*//g')
                    local CtrlVer=$FwVer'_'$NvdataVer
                else
                    local CtrlVer=$FwVer
                fi
            elif [ ${fwType} = "legacy" ];then
                local CtrlVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'BIOS Version' |awk -F '=' '{print $2}'| awk -F '_' '{print $1}'|sed -e 's/^[ \t]*//g')
            elif [ ${fwType} = "uefi" ];then
                local CtrlVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show |grep 'BIOS Version' |awk -F '=' '{print $2}'| awk -F '_' '{print $2}'|sed -e 's/^[ \t]*//g')
            elif [ ${fwType} = "cpld" ];then
                local CtrlVer=$($LSI_UPDATE_FW_TOOL /c$CtrlId show all |grep 'CPLD Version' |awk -F '=' '{print $2}'|sed -e 's/^[ \t]*//g')
            else
                redFont "lsi raid card(${ctrlModel}) $CtrlId fwtype is error " | tee -a lsi.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $CtrlId $fwType "failed" "--" $newVersion $updatetime
                continue
            fi
            if [ -z $CtrlVer ];then
                CtrlVer='0.0.0.0'
            fi

            if [ ${CtrlVer} = ${newVersion} ];then 
                greenFont "lsi raid card(${ctrlModel}) $CtrlId $fwType is new version(${newVersion}) in this server,no need to update " |tee -a lsi.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $CtrlId $fwType "success" $CtrlVer $newVersion $updatetime
                continue
            else
                if [ ${fwType} = "fw" ];then
                    update_result=$($LSI_UPDATE_FW_TOOL /c$CtrlId download file=$fwFile noverchk)
                    echo "raid card($ctrlModel) controller_id:$CtrlId $fwType $fwFile ${newVersion} result:${update_result}" >> ${UPDATE_LOG}
                    updatestatus=`echo ${update_result} |grep Status |grep Success|wc -l`
                    if [ 1 -eq $updatestatus ];then
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update OK" >>lsiresult.tmp
                    else
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update failed,please Check!" >>lsiresult.tmp
                    fi
                elif [ ${fwType} == "legacy" ];then
                    update_result=$($LSI_UPDATE_FW_TOOL /c$CtrlId  download bios file=$fwFile)
                    echo "raid card($ctrlModel) controller_id:$CtrlId $fwType $fwFile ${newVersion} result:${update_result}" >> ${UPDATE_LOG}
                    updatestatus=`echo ${update_result} |grep Status |grep Success|wc -l`
                    if [ 1 -eq $updatestatus ];then
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update OK" >>lsiresult.tmp
                    else
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update failed,please Check!" >>lsiresult.tmp
                    fi
                elif [ ${fwType} == "uefi" ];then
                    update_result=$($LSI_UPDATE_FW_TOOL /c$CtrlId  download efibios file=$fwFile)
                    echo "raid card($ctrlModel) controller_id:$CtrlId $fwType $fwFile ${newVersion} result:${update_result}" >> ${UPDATE_LOG}
                    updatestatus=`echo ${update_result} |grep Status |grep Success|wc -l`
                    if [ 1 -eq $updatestatus ];then
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update OK" >>lsiresult.tmp
                    else
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update failed,please Check!" >>lsiresult.tmp
                    fi
                elif [ ${fwType} == "cpld" ];then
                    update_result=$($LSI_UPDATE_FW_TOOL /c$CtrlId  download file=$fwFile noverchk)
                    echo "raid card($ctrlModel) controller_id:$CtrlId $fwType $fwFile ${newVersion} result:${update_result}" >> ${UPDATE_LOG}
                    updatestatus=`echo ${update_result}|grep Status |grep Success|wc -l`
                    if [ 1 -eq $updatestatus ];then
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update OK" >>lsiresult.tmp
                    else
                        echo "lsi raid card($ctrlModel) $CtrlId $fwType update failed,please Check!" >>lsiresult.tmp
                    fi
                fi
            fi
            if [ 1 -eq $updatestatus ];then
                result="success"
            else
                result="failed"
            fi
            endtime=`date +'%Y-%m-%d %H:%M:%S'`
            end_seconds=$(date --date="$endtime" +%s)
            updatetime=$((end_seconds-start_seconds))
            updateResult $ctrlModel $CtrlId $fwType $result $CtrlVer $newVersion $updatetime
        else
            continue
        fi
    done < updateLsiFW.tmp
    if [ -f "lsiresult.tmp" ];then
        lsiUpdateCheck "lsiresult.tmp" "$fwType" "$LsiContrlNum" "$ctrlModel"
        rm -rf "lsiresult.tmp"
    fi

}

##===================================#
# 功能： LSI的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件
##===================================#
function lsiMain()
{

    local deviceType=$1
    local vendorType=$2
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"  
    
    LSI_UPDATE_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${LSI_UPDATE_FW_TOOL_NAME}
    
    if [ ! -f "${LSI_UPDATE_FW_TOOL}" -o ! -f "${fullPathFw}" ]
    then
        redFont " ${LSI_UPDATE_FW_TOOL} or ${fullPathFw} dont exist"
        return 0
    fi
    
    #非配置文件中的参数处理    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then 
    
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listLsiDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    #固件升级
    case "$contrlModel" in 
    "SDLSA(SAS3008)"|"S1008(SAS3008)-1"|"S1008(SAS3008)-2"|"9305-16i"|"9341-8i"|"9361-8i"|"9361-16i"|"9400-8i"|"9400-16i"|"9440-8i"|"9460-8i"|"9460-16i"|"9500-8i"|"9500-16i"|"9560-8i"|"9560-16i"|"9540-8i")
        if [ $deviceType = "raid" -a $vendorType = "LSI" ];then
            updateLsiFW "${contrlModel}" "${fullPathFw}" "${fwVer}" "${fwType}"
        else
            echo "don't support $deviceType or $vendorType"
        fi
        ;;
      *)
        echo "don't support lsi raid card model :${contrlModel}" 
        ;;
    esac
}

lsiMain $@