#!/bin/bash

#升级fw工具
QLOGIC_UPDATE_FW_TOOL_NAME="qaucli"
QLE2690_FWA_FILE_NAME="fwa_2690.dat"
QLE2692_FWA_FILE_NAME="fwa_2692.dat"
QLE269x_FBC_FILE_NAME="Q27FBC.dat"
QLOGIC_UPDATE_FW_TOOL_RPM_NAME="QConvergeConsoleCLI-2.3.00-36.x86_64.rpm"



##===================================#
# 功能： 获取qlogic卡的数量
# 入参：$1 卡类型
#       $2 qlogic卡信息文件
# 输出：qlogic_num_file
##===================================#
function get_qlogic_num()
{
    local ctrlModel=$1
    local qlogic_info_file=$2
    local total_num=0
    while read myline
    do
        local cardtype=$(echo $myline|awk '{print$2}')
        if [ ${cardtype} = ${ctrlModel} ];then
            let total_num=total_num+1
        fi
    done <${qlogic_info_file}
    echo "$total_num" > "qlogic_num_file"
}

##===================================#
# 功能： QLOGIC信息查询
# 入参：配置文件 各列
#    $1  model    : 网卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息
##===================================#
function listQlogicDriveDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "default" ];then
        printf "%-10s %-10s %-12s %-10s %-11s %-8s %-3s\n"   Device  Verdor Instance Model FwType FwVer >>qlogic.list
    fi
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do
        local qlogic_type="unknown"
        qlogic_type=$(echo $myline |awk '{print$2}')
        if [ ${qlogic_type} = ${ctrlModel} ];then
            Instance=$(echo $myline |awk '{print $1}')
            if [ ${fwType} = "default" ];then
                # local CtrlVer=$($QLOGIC_UPDATE_FW_TOOL -i $Instance |grep 'Flash Firmware Version' | awk -F ':' '{print $2}' | sed -e 's/^[ \t]*//g')
                local version=$($QLOGIC_UPDATE_FW_TOOL -i ${Instance} VPD |grep 'Flash Image Version'|awk -F ':' '{print $2}' | sed -e 's/^[ \t]*//g')
                local CtrlVer="${version:0:2}.${version:2:2}.${version:4:2}.00"
            fi
            if [ ${CtrlVer} = ${newVer} ];then
                printf "\e[37m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "fc" "qlogic" ${Instance} ${ctrlModel} ${fwType} "${CtrlVer}"  >>qlogic.list
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "fc" "qlogic" ${Instance} ${ctrlModel} ${fwType} "${CtrlVer}"  >>qlogic.list
            fi
        else
            continue
        fi
    done < $infoFile
    IFS="$OLD_IFS"
    #echo -e ""     >>qlogic.list
}

##===================================#
# 功能： QLOGIC固件信息查询
# 入参：配置文件 各列
#     $1  model ：控制器类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息。
##===================================#
function listQlogicDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3

    if [ ! -f "QlogicInfo.tmp" ];then
        echo "scaning the qlogic fc card in server......."
        for Instance in `$QLOGIC_UPDATE_FW_TOOL -i | grep 'HBA Instance' | awk -F ':' '{print $2}'`
        do
            # instanceInfo=$($QLOGIC_UPDATE_FW_TOOL -i $Instance)
            hbaPort=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'HBA Port'| grep '1' | wc -l)
            if [ ${hbaPort} -eq 1 ];then
                deviceId=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'PCI Device ID'| awk -F ':' '{print $2}')
                subdeviceId=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'Subsystem Device ID'| awk -F ':' '{print $2}')
                subvendorId=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'Subsystem Vendor ID'| awk -F ':' '{print $2}')
                if [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x029b" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2690-SR                      >>QlogicInfo.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x029c" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2692-SR                      >>QlogicInfo.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x030a" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2742-ACE                     >>QlogicInfo.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x0306" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2690-ACE                     >>QlogicInfo.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x0307" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2692-ACE                     >>QlogicInfo.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x0309" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2740-ACE-SP                  >>QlogicInfo.tmp
                fi
            fi
        done
        if [ ! -f "QlogicInfo.tmp" ];then
            echo "no support qlogic fc card" >QlogicInfo.tmp
        fi
    fi

    get_qlogic_num "${ctrlModel}" "QlogicInfo.tmp"
    local TotalNum=`cat "qlogic_num_file"`
    rm -rf "qlogic_num_file"
    if [ $fwType = "default" ];then
        echo -e "====================qlogic fc card model(${ctrlModel}) info===================== " >>qlogic.list
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>qlogic.list
    fi
    if [ ${TotalNum} -ne 0 ]
    then
        listQlogicDriveDetails "${ctrlModel}" "QlogicInfo.tmp" "${newVer}" "$fwType"
    fi
}

##===================================#
# 功能： QLOGIC 网卡的固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
#       $3 : 待升级qlogic hba卡个数
##===================================#
function qlogicUpdateCheck()
{
    local qlogicresult=$1
    local fwType=$2
    local qlogicNum=$3
    local ctrlModel=$4
    updateNum=$(cat $qlogicresult | wc -l)
    if [ $updateNum -eq 0 ];then
        return 0
    fi
    fwFailed=$(cat $qlogicresult | grep ${ctrlModel} | grep "default update failed" | wc -l)
    fwSucced=$(cat $qlogicresult | grep ${ctrlModel} | grep "default update OK" | wc -l)
    if [ $fwType = "default" ];then
        if [ $fwFailed -eq 0 ];then
            greenFont "total qlogic card($ctrlModel) num:$qlogicNum,default succeed num:$fwSucced,default failed num:$fwFailed" | tee -a qlogic.result
        else
            redFont "total qlogic card($ctrlModel) num:$qlogicNum,default succeed num:$fwSucced,default failed num:$fwFailed,please Check!" | tee -a qlogic.result
            while read myline
            do
                defaultinfo=$(echo $myline | grep default | wc -l)
                if [ defaultinfo != 0 ];then               
                   redFont "$myline" | tee -a qlogic.result
                fi
            done <$qlogicresult
        fi
    fi
}

##===================================#
# 功能： QLOGIC 网卡的固件升级
# 入参:
#       $1 : Qlogic model:网卡芯片类型
#       $2 : fw_file：待升级固件
#       $3 : newVersion：待升级固件版本信息
#       $4 : fwType：待升级固件类型
##===================================#
function updateQlogicFW()
{
    local ctrlModel=$1
    local fwFile=$2
    local newVersion=$3
    local fwType=$4

    if [ ! -f "updateQlogicFW.tmp" ];then
        echo "scaning the qlogic fc card  for update in server......." | tee -a ${UPDATE_LOG}
        for Instance in `$QLOGIC_UPDATE_FW_TOOL -i | grep 'HBA Instance' | awk -F ':' '{print $2}'`
        do
            # instanceInfo=$($QLOGIC_UPDATE_FW_TOOL -i $Instance)
            hbaPort=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'HBA Port'| grep '1' | wc -l)
            if [ ${hbaPort} -eq 1 ];then
                deviceId=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'PCI Device ID'| awk -F ':' '{print $2}')
                subdeviceId=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'Subsystem Device ID'| awk -F ':' '{print $2}')
                subvendorId=$($QLOGIC_UPDATE_FW_TOOL -i $Instance|grep 'Subsystem Vendor ID'| awk -F ':' '{print $2}')
                if [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x029b" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2690-SR                      >>updateQlogicFW.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x029c" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2692-SR                      >>updateQlogicFW.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x030a" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2742-ACE                     >>updateQlogicFW.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x0306" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2690-ACE                     >>updateQlogicFW.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x0307" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2692-ACE                     >>updateQlogicFW.tmp
                elif [ ${deviceId} = "0x2261" ] && [ ${subdeviceId} = "0x0309" ] && [ ${subvendorId} = "0x1077" ];then
                    echo $Instance QLE2740-ACE-SP                  >>updateQlogicFW.tmp
                fi
            fi
        done
        if [ ! -f "updateQlogicFW.tmp" ];then
            echo "no support qlogic fc card" >updateQlogicFW.tmp
        fi
    fi

    get_qlogic_num "${ctrlModel}" "updateQlogicFW.tmp"
    local QlogicCardNum=`cat "qlogic_num_file"`
    rm -rf "qlogic_num_file"

    if [ ${QlogicCardNum} -eq 0 ]
    then
        echo -e "Total qlogic fc card(${ctrlModel}) num: 0,success num : 0" |tee -a qlogic.result
        greenFont "no qlogic fc card (${ctrlModel}) in this server,no need to update" |tee -a qlogic.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no card"
        return 0
    fi
    while read myline
    do
        local qlogic_type="unknown"
        qlogic_type=$(echo $myline | awk '{print $2}')
        if [ ${qlogic_type} = ${ctrlModel} ];then
            starttime=`date +'%Y-%m-%d %H:%M:%S'`
            start_seconds=$(date --date="$starttime" +%s)
            Instance=$(echo $myline | awk -F ' ' '{print $1}')
            if [ ${fwType} = "default" ];then
                # local CtrlVer=$($QLOGIC_UPDATE_FW_TOOL -i $Instance |grep 'Flash Firmware Version' | awk -F ':' '{print $2}' | sed -e 's/^[ \t]*//g')
                local version=$($QLOGIC_UPDATE_FW_TOOL -i ${Instance} VPD |grep 'Flash Image Version'|awk -F ':' '{print $2}' | sed -e 's/^[ \t]*//g')
                local CtrlVer="${version:0:2}.${version:2:2}.${version:4:2}.00"
            else
                redFont "qlogic fc card(${ctrlModel}) $Instance fwtype is error " | tee -a qlogic.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $Instance $fwType "failed" "--" $newVersion $updatetime
                continue
            fi

            if [ ${CtrlVer} = ${newVersion} ];then 
                greenFont "qlogic fc card(${ctrlModel}) $Instance $fwType is new version(${newVersion}) in this server,no need to update " |tee -a qlogic.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $Instance $fwType "success" $CtrlVer $newVersion $updatetime
                continue
            else
                if [ ${fwType} = "default" ];then
                    updatestatus1=`$QLOGIC_UPDATE_FW_TOOL -b $Instance $fwFile |grep Fail |wc -l`
                    updatestatus2="0"
                    updatestatus3="0"
                    # 2690和2692 SR卡需要升级不同的FWA文件
                    if [ $ctrlModel == "QLE2690-SR" ];then
                        updatestatus2=`$QLOGIC_UPDATE_FW_TOOL -u $Instance $QLE2690_FWA_FILE |grep Fail |wc -l`
                    elif [ $ctrlModel == "QLE2692-SR" ];then
                        updatestatus2=`$QLOGIC_UPDATE_FW_TOOL -u $Instance $QLE2692_FWA_FILE |grep Fail |wc -l`
                    fi
                    # 2690和2692 SR卡需要升级相同的FBC文件
                    case "$ctrlModel" in 
                    "QLE2690-SR"|"QLE2692-SR")
                        updatestatus3=`$QLOGIC_UPDATE_FW_TOOL -sp $Instance $QLE269x_FBC_FILE |grep Fail |wc -l`
                    esac
                    updatestatus=$(($updatestatus1+$updatestatus2+$updatestatus3))
                    if [ 0 -eq $updatestatus ];then
                        result="success"
                        echo "qlogic fc card($ctrlModel) $Instance $fwType update OK" >>qlogicresult.tmp
                    else
                        result="failed"
                        echo "qlogic fc card($ctrlModel) $Instance $fwType update failed,please Check!" >>qlogicresult.tmp
                    fi
                    endtime=`date +'%Y-%m-%d %H:%M:%S'`
                    end_seconds=$(date --date="$endtime" +%s)
                    updatetime=$((end_seconds-start_seconds))
                    updateResult $ctrlModel $Instance $fwType $result $CtrlVer $newVersion $updatetime
                fi
            fi
        else
            continue
        fi
    done < updateQlogicFW.tmp
    if [ -f "qlogicresult.tmp" ];then
        qlogicUpdateCheck "qlogicresult.tmp" "$fwType" "$QlogicCardNum" "$ctrlModel"
        rm -rf "qlogicresult.tmp"
    fi

}

##===================================#
# 功能： QLOGIC的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件
##===================================#
function qlogicMain()
{

    local deviceType=$1
    local vendorType=$2
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"

    QLOGIC_UPDATE_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${QLOGIC_UPDATE_FW_TOOL_NAME}
    QLE2690_FWA_FILE=${SCRIPT_PATH}"/"${fwToolsDir}"/"${QLE2690_FWA_FILE_NAME}
    QLE2692_FWA_FILE=${SCRIPT_PATH}"/"${fwToolsDir}"/"${QLE2692_FWA_FILE_NAME}
    QLE269x_FBC_FILE=${SCRIPT_PATH}"/"${fwToolsDir}"/"${QLE269x_FBC_FILE_NAME}
    QLOGIC_UPDATE_FW_TOOL_RPM==${SCRIPT_PATH}"/"${fwToolsDir}"/"${QLOGIC_UPDATE_FW_TOOL_RPM_NAME}

    if [ ! -f "${QLOGIC_UPDATE_FW_TOOL}" -o ! -f "${fullPathFw}" ]
    then
        redFont " ${QLOGIC_UPDATE_FW_TOOL} or ${fullPathFw} dont exist"
        return 0
    fi
    
    #非配置文件中的参数处理    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then 
    
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listQlogicDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    #固件升级
    case "$contrlModel" in 
    "QLE2742-ACE"|"QLE2690-SR"|"QLE2692-SR"|"QLE2690-ACE"|"QLE2692-ACE"|"QLE2740-ACE-SP")
        if [ $deviceType = "fc" -a $vendorType = "QLOGIC" ];then
            updateQlogicFW "${contrlModel}" "${fullPathFw}" "${fwVer}" "${fwType}"
        else
            echo "don't support $deviceType or $vendorType"
        fi
        ;;
      *)
        echo "don't support qlogic fc card model :${contrlModel}" 
        ;;
    esac
}

qlogicMain $@