# Copyright (C) Nov 2020 Mellanox Technologies Ltd. All rights reserved.
# Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
#
# This software is available to you under a choice of one of two
# licenses.  You may choose to be licensed under the terms of the GNU
# General Public License (GPL) Version 2, available from the file
# COPYING in the main directory of this source tree, or the
# OpenIB.org BSD license below:
#
#     Redistribution and use in source and binary forms, with or
#     without modification, are permitted provided that the following
#     conditions are met:
#
#      - Redistributions of source code must retain the above
#        copyright notice, this list of conditions and the following
#        disclaimer.
#
#      - Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials
#        provided with the distribution.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# --

from enum import Enum, IntEnum

STATUS_SUCCESS = 0
STATUS_FAIL = 1

STE_TERMINATOR = -1

ERROR_BUFFER_SIZE = 256


class RunningMode(Enum):
    LIVE = 'live'
    OFFLINE = 'offline'


class PacketType(Enum):
    HEX = 'hex'
    PCAP = 'pcap'
    RAW = 'raw'


class PacketSource(Enum):
    EGRESS = 'egress'
    INGRESS = 'ingress'


class ProviderType(Enum):
    RESOURCEDUMP = 'resourcedump'


class QPFlags(IntEnum):
    FORCE_LOOPBACK = 1  # 1 << 0
    SPECIAL_ROOT = 2  # 1 << 1


class PacketAttributeFlags(IntEnum):
    EGRESS = 1  # 1 << 0
    INGRESS = 2  # 1 << 1
    REG_A = 4  # 1 << 2


class SegmentType(IntEnum):
    MDFY_HDR_RNG = 0x1020
    STE_RANGE = 0x1310
    STE_GLOBAL_RNG = 0x1312
    STE_ROOT = 0x1313


class HardwareDeviceID(IntEnum):
    BlueField = 0x211
    BlueField2 = 0x214
    BlueField3 = 0x21c
    ConnectX4 = 0x209
    ConnectX4LX = 0x20b
    ConnectX5 = 0x20d
    ConnectX6 = 0x20f
    ConnectX6DX = 0x212
    ConnectX6LX = 0x216
    ConnectX7 = 0x218


SUPPORTED_DEVICES = [
    HardwareDeviceID.BlueField.value,
    HardwareDeviceID.ConnectX4.value,
    HardwareDeviceID.ConnectX4LX.value,
    HardwareDeviceID.ConnectX5.value,
    HardwareDeviceID.ConnectX6.value
]
