/*
 * Copyright (C) Jan 2013 Mellanox Technologies Ltd. All rights reserved.
 * Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef __MTCR_MF__
#define __MTCR_MF__
#include "mtcr_com_defs.h"
#ifdef __FreeBSD__
#include <sys/pciio.h>
#endif


/*  All fields in follow structure are not supposed to be used */
/*  or modified by user programs. Except i2c_secondary that may be */
/*  modified before each access to target I2C secondary address */
struct mfile_t
{
    MType tp; /*  type of driver */
#ifndef __WIN__
    MType orig_tp;
#endif
    MType res_tp;         /*  Reserved type of driver for HCR usage */
    DType dtype;          /*  target device to access to */
    DType itype;          /*  interface device to access via */
    int is_i2cm;          /*  use device as I2C primary */
#ifndef __WIN__
    int is_vm;            /*  if the machine is VM    */
    int cr_access;        /* If cr access is allowed in MLNXOS devices */
    io_region* iorw_regions; /* For LPC devices */
    int regions_num;
    char* dev_name;
#endif
    char real_name[DEV_NAME_SZ];
    cables_info ext_info; /*keeps info for calculate the correct secondary address (0x50 + offset) */
    unsigned char i2c_secondary;
    int gpio_en;
    void* ctx;
#ifdef __WIN__
    void* ptr;
    long mtusb_serial; // TODO use dinfo instead
    MT_ulong_ptr_t fd;
    MT_ulong_ptr_t res_fd;
#else
    int fd;
    int res_fd;                   /*  Will be used with HCR if need*/
    int is_mtserver_req;          // request came from mtServer - means came from remote client
    void* bar_virtual_addr;
    unsigned int bar0_gw_offset; // for MST_BAR0_GW_PCI devices, offset from BAR0 - gateway - for R/W operations
    int file_lock_descriptor; // file descriptor to the lock file aka semaphore in order to protect parallel read/write
                              // GW operations
    unsigned long long start_idx;
    void* fallback_mf;
    ctx_params context; // for UEFI
    // for mst driver compatibility
    int old_mst;
    unsigned short mst_version_major;
    unsigned int mst_version_minor;
    mtcr_status_e icmd_support;
    unsigned int vsec_addr;
    u_int32_t vsec_cap_mask;
    int multifunction;
    void* ul_ctx;
    f_mpci_change mpci_change;
    unsigned int jtag_index;
#endif
    unsigned int cr_space_offset; // Default is 0. for NVIDIA devices starting from GB-100 - might change.
    unsigned int map_size;
    MIB_Private mib; /*  Data for IB interface (if relevant) */
    int vsec_supp;
    int use_smp;
    int use_class_a;
    int i2c_smbus;
    unsigned int i2c_RESERVED; /*  Reserved for internal usage (i2c internal) */
    enum Mdevs_t flags;
    u_int32_t connectx_wa_slot; /* apply connectx cr write workaround */
    int connectx_wa_last_op_write;
    u_int32_t connectx_wa_stat;
    u_int64_t connectx_wa_max_retries;
    u_int64_t connectx_wa_num_of_writes;
    u_int64_t connectx_wa_num_of_retry_writes;
    int server_ver_major;
    int server_ver_minor;
    dev_info* dinfo;
    icmd_params icmd;
    int address_space;
    // for tools HCR access
    tools_hcr_params hcr_params;
    // for sending access registers
    access_reg_params acc_reg_params;
    // Dynamic libs Ctx
    void* dl_context;
    // Cables CTX
    int is_cable;
    void* cable_ctx;
    unsigned int linkx_chip_devid;
    void* cable_chip_ctx; // TODO change the name
    // Amos gear-box
    gearbox_info gb_info;
    unsigned int proto_type;
    int sock;                     /*  in not -1 - remote interface */
    int using_ssh;
    int is_remote;
#ifdef __FreeBSD__
    struct pcisel sel;
    unsigned int vpd_cap_addr;
    int wo_addr;
    int connectx_flush;
    int fdlock;
#endif

    // For dma purpose
    void* dma_props;

    struct page_list user_page_list;
};

#endif
