import logging
from cli_wrapping_utils import *
from mlxburn_constants import MLXVPD_PROGRAM
from modes.mlxburn_mode import I_MlxburnMode
from mlxburn_utils import execute_check


class ShowVpdMode(I_MlxburnMode):
    def execute(self):
        cmd = self.prepare_vpd_command()
        logging.debug("Running {}".format((cmd)))
        execute_check(cmd, "Failed to Read VPD: {rc}", None)

    def prepare_vpd_command(self):
        cmd_gen = CmdGenerator(MLXVPD_PROGRAM)
        I_OptArgGenerator.set_option_prefix("-")

        cmd_gen.add_argument(inputArgPipeOAG("d", self._args.mst_dev))
        if self._args.vpd_rw:
            cmd_gen.add_argument(addFlagOAG("vpd_rw"))

        return cmd_gen.get_cmd()
