#!/bin/bash

ST_UPDATE_TOOL_NAME="SeaChest_Basics_Raid"


#жϳɹı׼ҪmodelĴ==   ϵͳд̰汾 >= ̼汾ĴĿ

#ж ΪmodelţҰ汾Сڴ汾߲ ߴ

##===================================#
# ܣ жǷҪ
#    $1 : oldversion  $2 : newversion
#  ֵ 1 Ҫ
#         0: Ҫ     
##===================================#
function isSeagateNeedUpdate()
{
    if [ "$1" != "$2" ]
    then
        return 1
    else
        return 0
    fi
}

##===================================#
# ܣ ϣӲϢѯ
# Σļ 
#     $1  model ;
#    $2   filename
#ӲɹʧܵʾӲϸϢ ̣ͺţкţǰ̼汾ŵϢ
##===================================#
function listSeagateDriveDetails()
{
    local driveModel=$1
    local infoFile=$2
    local newVer=$3
    
    if [ -f "${SAS_TOPO}" ]
    then
       printf "%-10s %-10s %-20s %-16s %-8s %-4s %-3s\n"   Device  Verdor  Model   SerialNum  FwVer EID Slot >>seagate.list
    else
       printf "%-10s %-10s %-20s %-16s %-8s\n"   Device  Verdor  Model   SerialNum  FwVer >>seagate.list
    fi 
    local drivesInfo=`cat ${infoFile}|awk '!a[$4]++'|grep -i "$driveModel"`
    OLD_IFS="$IFS"
    IFS=$'\n'
    for drives in $drivesInfo
    do 
        
        local driveVer=`echo $drives |awk '{print $5}' `        
        local driveSN=`echo $drives |awk '{print $4}' `
        if [ -f "${SAS_TOPO}" ]
        then
        local slot=`cat ${SAS_TOPO} |grep   ${driveSN}|awk '{print $4}'`
        local eid=`cat ${SAS_TOPO} |grep   ${driveSN}|awk '{print $3}'`
        fi 
        #echo -e "harddisk" "SEGATE" "${driveModel}  ${driveSN}  ${driveVer}" 
        
        if [ "${driveVer}" == "${newVer}" ]
        then 
            printf "%-10s %-10s %-20s %-16s %-8s %-4s %-3s \n" "harddisk" "SEGATE" ${driveModel}  ${driveSN}  ${driveVer}  ${eid}  ${slot}  >>seagate.list
        else
            echo "need update" >>${NEED_UPDATE_FLAG}
            printf "\e[31m%-10s %-10s %-20s %-16s %-8s %-4s %-3s \e[0m\n" "harddisk" "SEGATE" ${driveModel}  ${driveSN}  ${driveVer}  ${eid}  ${slot}  >>seagate.list
        fi
    done
    IFS="$OLD_IFS" 
    echo -e ""     >>seagate.list
}

##===================================#
# ܣ ϣӲϢѯ
# Σļ 
#     $1  model ;
#ӲʾӲϸϢ ̣ͺţкţǰ̼汾ŵϢ
##===================================#
function listSeagateDrive()
{
    local driveModel=$1
    local newVer=$2
      
    if [ ! -f "SeagateInfo.tmp" ]
    then
        echo "scaning the device in server......."
        $ST_UPDATE_TOOL -S |awk '!a[$4]++' >SeagateInfo.tmp
    fi
    
    local TotalNum=`cat SeagateInfo.tmp|awk '!a[$4]++'|grep -i "$driveModel"|wc -l`
    
    echo -e "====================seagate drive model(${driveModel}) info===================== " >>seagate.list
                                            
    printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>seagate.list                    
    
    if [ ${TotalNum} -ne 0 ]
    then 
        listSeagateDriveDetails "${driveModel}" "SeagateInfo.tmp" "${newVer}"
    fi        
    
}
##===================================#
# ܣ ϣӲϢѯ
# Σļ 
#     $1  model ;
#ӲɹʧܵʾӲϸϢ ̣ͺţкţǰ̼汾ŵϢ
##===================================#
function listSeagateDriveAfterUpdate()
{
    local driveModel=$1
    local newVersion=$2
    
    $ST_UPDATE_TOOL -S |awk '!a[$4]++'|grep -i "$driveModel" >segainfo.tmp
    
    local TotalNum=`cat segainfo.tmp|awk '!a[$4]++'|grep -i "$driveModel"|wc -l`
    local UpdateNum=`cat segainfo.tmp |grep "${newVersion}"|wc -l` 
    local FailNum=0
    let FailNum=${TotalNum}-${UpdateNum}
    echo -e "==============seagate drive model(${driveModel}) info=============== " >>seagate.list
    
                                        
    printf "%-10s %-8s %-4s\n"   TotalNum UpdateNum FailNum  >>seagate.list                     
    printf "%-12s %-12s %-8s\n"   ${TotalNum} ${UpdateNum} ${FailNum}  >>seagate.list    
    
    if [ ${TotalNum} -ne 0 ]
    then 
        listSeagateDriveDetails "${driveModel}" "segainfo.tmp"  "${newVersion}"
    fi
    rm -f segainfo.tmp
}

##===================================#
# ܣ   
#    $1 : model  $2 : newversion  $3 : updatetime
#
# ޸ļ¼ 1.newVerDrivenum ѯǰmodelģΪͬmodelܲͬĹ̼汾¹̼model       
##===================================#
function checkSeagateUpdateResult()
{
    local driveModel=$1
    local newVersion=$2
    local updatetime=$3
    
    $ST_UPDATE_TOOL -S |awk '!a[$4]++' >stupdatecheck.tmp
    
    local newVerDriveNum=`cat stupdatecheck.tmp |grep "${driveModel}"|grep "${newVersion}"|wc -l` 
    local modelDriveNum=`cat stupdatecheck.tmp |grep "${driveModel}"|wc -l`
    echo -e "Total drive(${driveModel}) num: ${modelDriveNum},success num : ${newVerDriveNum}" |tee -a seagate.result
    
    listSeagateDriveAfterUpdate "${driveModel}" "${newVersion}"
    
    if [ ${newVerDriveNum} -eq ${modelDriveNum} ]
    then
        updateResult $driveModel "all" "default" "success" "--" $newVersion $updatetime
        greenFont "All Disk(${driveModel}) Update successfully!"          |tee -a seagate.result
    else
        updateResult $driveModel "all" "default" "failed" "--" $newVersion $updatetime
        redFont "NOT All Disk(${driveModel}) FW Updated,please Check!"    |tee -a seagate.result
    fi
    echo "${driveModel}" "${newVersion}" "update Finished"
    
    rm -f stupdatecheck.tmp
}

##===================================#
# ܣ ϣӲ̵Ĺ̼
#    $1 : drive model  $2 : fw_file
#       $3 : newVersion
##Vendor   Handle       Model Number            Serial Number          FwRev
#TOSHIBA  /dev/sg0     AL13SEB600              15C0A066FTR7           0101
##===================================#
function updateSeagateFW()
{
    local driveModel=$1
    local fwFile=$2
    local newVersion=$3
    local needUpdateDrive=0;    
    

    
    if [ ! -f "updateSeagateFW.tmp" ]
    then
        echo "scaning the device in server......." |tee -a ${UPDATE_LOG}
        $ST_UPDATE_TOOL -S |awk '!a[$4]++' >updateSeagateFW.tmp
    fi

    driveModelNum=`cat updateSeagateFW.tmp |grep "${driveModel}" |wc -l`
    if [ ${driveModelNum} -eq 0 ]
    then 
        echo -e "Total drive(${driveModel}) num: 0,success num : 0" |tee -a seagate.result
        greenFont "no drive (${driveModel}) in this server,no need to update" |tee -a seagate.result
        updateResult $driveModel "--" "default" "success" "--" "--" "0" "no disk"
        return 0
    fi 

    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    newVerNum=`cat updateSeagateFW.tmp |grep "${driveModel}" |grep "${newVersion}"|wc -l`

    if [ ${driveModelNum} -eq ${newVerNum} ]
    then 
        echo -e "Total drive(${driveModel}) num: ${driveModelNum},success num : ${driveModelNum}" |tee -a seagate.result
        greenFont "all drives (${driveModel}) are new version(${newVersion}) in this server,no need to update " |tee -a seagate.result
        endtime=`date +'%Y-%m-%d %H:%M:%S'`
        end_seconds=$(date --date="$endtime" +%s)
        updatetime=$((end_seconds-start_seconds))
        updateResult $driveModel "all" "default" "success" $newVersion $newVersion $updatetime
        return 0
    fi 
    
    #local drivesInfo=`$ST_UPDATE_TOOL -S |awk '!a[$4]++'|grep -i "$driveModel"` 
    local drivesInfo=`cat updateSeagateFW.tmp |grep "${driveModel}"`
    # sg storcliϵĹ̼汾ʵʱѯģǵǰϢ
    OLD_IFS="$IFS"
    IFS=$'\n'
    for drives in $drivesInfo
    do
        driveHandle=`echo $drives |awk '{print $2}' ` 
        driveVer=`echo $drives |awk '{print $5}' `
        isSeagateNeedUpdate "${driveVer}"  "${newVersion}"
        if [ 1 -eq $? ]
        then
            echo "updating  " $needUpdateDrive  "drive"
            let needUpdateDrive=needUpdateDrive+1        
            $ST_UPDATE_TOOL --downloadFW $fwFile  -d  ${driveHandle} |tee -a ${UPDATE_LOG}
            local checkVer1=`$ST_UPDATE_TOOL -i -d ${driveHandle} |grep "Firmware Revision"|cut -d ":" -f2`
            local checkVer=`eval echo ${checkVer1}`  #kill space 
            if [ -n "${checkVer}" -a "${checkVer}" != "${newVersion}" ]
            then
                echo "=${checkVer}= in harddisk,expected is =${newVersion}=,updating again" |tee -a ${UPDATE_LOG}
                $ST_UPDATE_TOOL --downloadFW $fwFile  -d  ${driveHandle} |tee -a ${UPDATE_LOG}
            fi
        fi
        #echo $drives
        #echo $driveHandle  $driveVer
    done
    IFS="$OLD_IFS" 

    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    checkSeagateUpdateResult "${driveModel}" "${newVersion}" "${updatetime}"
}


## 1)case ƥĴmodelԺܻȽ϶࣬ôչ
## 2) ̼Ƚϴİ汾£
supportModel=("ST6000NM021A"  "ST600MM0099")

##===================================#
# ܣ ϣӲ̵Ĺ̼
# Σļ 
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 ̼Ĺ·
#     $7  ̼İ汾ļ
##===================================#
function seagateMain()
{
    
    local diskModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7
    
    
    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"  
    
    ST_UPDATE_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${ST_UPDATE_TOOL_NAME}
    
    
    if [ ! -f "${ST_UPDATE_TOOL}" -o ! -f "${fullPathFw}" ]
    then
        redFont " ${ST_UPDATE_TOOL} or ${fullPathFw} dont exist"
        return 0
    fi
    
    #ļеĲ    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then 
    
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listSeagateDrive "${diskModel}" "${fwVer}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    #̼
    case "$diskModel" in 
    "ST6000NM021A"|"ST600MM0099"|"ST1200MM0129"|"ST2400MM0129"|"ST1800MM0129"|"ST8000NM000A")
         updateSeagateFW "${diskModel}" "${fullPathFw}"  "${fwVer}"
        ;;
      *)
        echo "don't support seagate model :${diskModel}" 
        ;;
    esac
}

seagateMain $@