#!/bin/bash
# lsi控制器升级希捷硬盘

ORA_PATH=`pwd`
LOCAL_COMMON_ENTRY=$ORA_PATH"/scripts/cmn/common.sh"
PATHCFG_ENTRY=$ORA_PATH"/""pathcfg.sh"

function lsi_update_disk()
{
    local model=$1
    local cardid=$2
    local eid=$3
    local slotid=$4
    local fwfile=$5
    local fwtype=$6
    local newVersion=$7
    ${lsi_tool} /c$cardid /e$eid /s$slotid download src=$fwfile
    if [ $? -eq 0 ];then
        echo "seagete disk ($model) $fwtype update OK" >>seagate_lsi_result.tmp
    else
        echo "seagete disk ($model) $fwtype update failed,please Check!" >>seagate_lsi_result.tmp
    fi
    # lsi卡升级一个固件后，需要延时，不然会升级卡死或失败
    echo "it will update next firmware ,please wait 80 seconds ..."
    sleep 80
}



function SeagateLsiUpdateCheck()
{
    local result_file=$1
    local fwtype=$2
    local update_num=$3
    local model=$4
    local newVersion=$5
    local updatetime=$6
    fwsuccess=$(cat ${result_file} |grep -c "fw update OK")
    fwfailed=$(cat ${result_file} |grep -c "fw update failed,please Check")
    bridgesuccess=$(cat ${result_file} |grep -c "bridge update OK")
    bridgefailed=$(cat ${result_file} |grep -c "bridge update failed,please Check")
    if [ "x${fwtype}" = "xfw" ];then
        if [ ${fwfailed} -eq 0 ];then
            greenFont "total seagate disk in lsi controller need update($model) num:$update_num,fw succeed num：$fwsuccess,fw failed num：$fwfailed" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "success" "--" $newVersion $updatetime "in lsi controller"
        else
            redFont "total seagate disk in lsi controller need update($model) num:$update_num,fw succeed num：$fwsuccess,fw failed num：$fwfailed, please check!!" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "failed" "--" $newVersion $updatetime "in lsi controller"
        fi
    elif [ "x${fwtype}" = "xbridge" ];then
        if [ ${bridgefailed} -eq 0 ];then
            greenFont "total seagate disk in lsi controller need update($model) num:$update_num,bridge succeed num: $bridgesuccess,bridge failed num: $bridgefailed" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "success" "--" $newVersion $updatetime "in lsi controller"
        else
            redFont "total seagate disk in lsi controller need update($model) num:$update_num,bridge succeed num: $bridgesuccess,bridge failed num: $bridgefailed, please check!!" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "failed" "--" $newVersion $updatetime "in lsi controller"
        fi
    fi
}




function seagate_lsi_main()
{
    local cardid=$1
    local disk_model=$2
    local fwfile=$3
    local newVersion=$4
    local fwtype=$5
    lsi_tool=$6
    local lsi_total_disk=0
    local already_new_version=0
    local need_update=0
    source $LOCAL_COMMON_ENTRY
    source $PATHCFG_ENTRY
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    ${lsi_tool} /c$cardid /eall /sall show |grep "${disk_model}"> lsi_disk_info.txt
    while read line
    do
        let lsi_total_disk=lsi_total_disk+1
        local eid=$(echo $line |awk '{print $1}'| awk -F: '{print $1}')
        local slotid=$(echo $line |awk '{print $1}'| awk -F: '{print $2}')
        local firmware_version=$(${lsi_tool} /c$cardid /e$eid /s$slotid show all |grep -i "Firmware Revision"|awk '{print $4}')
        if [ "x$firmware_version" = "x$newVersion" ];then
            let already_new_version=already_new_version+1
        else
            lsi_update_disk "${disk_model}" "${cardid}" "${eid}" "${slotid}" "${fwfile}" "${fwtype}" "${newVersion}"
        fi
    done < lsi_disk_info.txt
    rm -f lsi_disk_info.txt
    let need_update=lsi_total_disk-already_new_version
    
    if [ ${lsi_total_disk} -eq 0 ];then
        greenFont "no seagate disk (${disk_model}) under lsi controller in this server,do not need update ${fwtype}" | tee -a seagate.result
        updateResult $disk_model "--" "$fwtype" "success" "--" "--" "0" "no disk in lsi controller"
        return 0
    fi
    if [ ${need_update} -eq 0 ];then
        endtime=`date +'%Y-%m-%d %H:%M:%S'`
        end_seconds=$(date --date="$endtime" +%s)
        updatetime=$((end_seconds-start_seconds))
        greenFont "all seagate disk (${disk_model}) in lsi controller fwtype (${fwtype}) already newversion,do not need update" | tee -a seagate.result
        updateResult $disk_model "all" "$fwtype" "success" $newVersion $newVersion $updatetime "in lsi controller"
        return 0
    fi
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ -f "seagate_lsi_result.tmp" ];then
        SeagateLsiUpdateCheck "seagate_lsi_result.tmp" "$fwtype" "$need_update" "$disk_model" "${newVersion}" "${updatetime}"
        rm -f "seagate_lsi_result.tmp"
    fi
}



seagate_lsi_main $@