#!/bin/bash
ORA_PATH=`pwd`
LOCAL_COMMON_ENTRY=$ORA_PATH"/scripts/cmn/common.sh"
PATHCFG_ENTRY=$ORA_PATH"/""pathcfg.sh"

function SeagatePmcUpdateCheck()
{
    local result_file=$1
    local fwtype=$2
    local update_num=$3
    local model=$4
    local newVersion=$5
    local updatetime=$6
    fwsuccess=$(cat ${result_file} |grep -c "fw update OK")
    fwfailed=$(cat ${result_file} |grep -c "fw update failed,please Check")
    bridgesuccess=$(cat ${result_file} |grep -c "bridge update OK")
    bridgefailed=$(cat ${result_file} |grep -c "bridge update failed,please Check")
    if [ "x${fwtype}" = "xfw" ];then
        if [ ${fwfailed} -eq 0 ];then
            greenFont "total seagate disk in pmc controller need update($model) num:$update_num,fw succeed num：$fwsuccess,fw failed num：$fwfailed" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "success" "--" $newVersion $updatetime "in pmc controller"
        else
            redFont "total seagate disk in pmc controller need update($model) num:$update_num,fw succeed num：$fwsuccess,fw failed num：$fwfailed, please check!!" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "failed" "--" $newVersion $updatetime "in pmc controller"
        fi
    elif [ "x${fwtype}" = "xbridge" ];then
        if [ ${bridgefailed} -eq 0 ];then
            greenFont "total seagate disk in pmc controller need update($model) num:$update_num,bridge succeed num: $bridgesuccess,bridge failed num: $bridgefailed" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "success" "--" $newVersion $updatetime "in pmc controller"
        else
            redFont "total seagate disk in pmc controller need update($model) num:$update_num,bridge succeed num: $bridgesuccess,bridge failed num: $bridgefailed, please check!!" |tee -a seagate.result
            updateResult $model "all" "${fwtype}" "failed" "--" $newVersion $updatetime "in pmc controller"
        fi
    fi
}


function update_firmware()
{
    local channel_device_info=$1
    local fwfile=$2
    local fwtype=$3
    local cardid=$4
    local model=$5
    local channel=$(echo ${channel_device_info} | awk -F, '{print $1}')
    local device=$(echo ${channel_device_info} | awk -F, '{print $2}')
    ${PMC_TOOL_ARCCONF} imageupdate ${cardid} device ${channel} ${device} 32768 ${fwfile} 239 noprompt
    if [ $? -eq 0 ];then
        echo "seagete disk ($model) $fwtype update OK" >>seagate_pmc_result.tmp
    else
        echo "seagete disk ($model) $fwtype update failed,please Check!" >>seagate_pmc_result.tmp
    fi
}


function seagate_pmc_main()
{
    local cardid=$1
    local model=$2
    local fullPathFw=$3
    local newVersion=$4
    local fwtype=$5
    PMC_TOOL_ARCCONF=$6
    local model_total=0
    local already_total=0
    local need_update=0
    local disk_num=0
    local disk_info_tmp_file="disk_info.tmp"
    source $LOCAL_COMMON_ENTRY
    source $PATHCFG_ENTRY
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    ${PMC_TOOL_ARCCONF} getconfig $cardid pd |sed -n '/Device is a Hard drive/,/Serial number\s*:/p'| grep -v 'Array' > ${disk_info_tmp_file}
    local exist_disk_flag=$(cat ${disk_info_tmp_file} |grep -c "Device is a Hard drive")
    if [ ${exist_disk_flag} -eq 0 ];then
        greenFont "no disk (${model}) under pmc controller,do not need update"
        return 0
    fi
    sed -i '/Device is a Hard drive/i\|' ${disk_info_tmp_file}
    disk_info_string=$(cat ${disk_info_tmp_file})
    OLD_IFS="$IFS"
    IFS="|"
    local disk_info_arr=($disk_info_string)
    
    IFS="$OLD_IFS"
    local arr_length=${#disk_info_arr[@]}
    let disk_num=arr_length-1
    for((i=1;i<=$disk_num;i++))
    do
        local single_disk_info=${disk_info_arr[i]}
        local channel_device=$(echo "${single_disk_info}" |grep "Reported Channel,Device" | awk '{print $NF}'|awk -F "(" '{print $1}')
        local model_tmp=$(echo "${single_disk_info}" | grep "Model" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        local Firmware=$(echo "${single_disk_info}" | grep "Firmware" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        match_flag=$(echo ${model_tmp}| grep -c ${model})
        if [ ${match_flag} -ne 0 ];then
            let model_total=model_total+1
            if [ "x${newVersion}" = "x${Firmware}" ];then
                let already_total=already_total+1
            else
                update_firmware "${channel_device}" "${fullPathFw}" "${fwtype}" "${cardid}" "${model}"
            fi
        fi
    done
    let need_update=model_total-already_total
    if [ ${model_total} -eq 0 ];then
        greenFont "no seagate disk (${model}) under pmc controller in this server,do not need update ${fwtype}" | tee -a seagate.result
        updateResult $model "--" "$fwtype" "success" "--" "--" "0" "no disk in pmc controller"
        return 0
    fi
    if [ ${need_update} -eq 0 ];then
        endtime=`date +'%Y-%m-%d %H:%M:%S'`
        end_seconds=$(date --date="$endtime" +%s)
        updatetime=$((end_seconds-start_seconds))
        greenFont "all seagate disk (${model}) in pmc controller fwtype (${fwtype}) already newversion,do not need update" | tee -a seagate.result
        updateResult $model "all" "$fwtype" "success" $newVersion $newVersion $updatetime "in pmc controller"
        return 0
    fi
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ -f "seagate_pmc_result.tmp" ];then
        SeagatePmcUpdateCheck "seagate_pmc_result.tmp" "$fwtype" "$need_update" "$model" "$newVersion" "$updatetime"
        rm -f "seagate_pmc_result.tmp"
    fi
}





seagate_pmc_main $@