#!/bin/bash

ARCCONF_NAME="arcconf-linux"
STORCLI_LINUX="storcli-linux"


function list_drive_pmc()
{
    local cardid=$1
    local model=$2
    local newverion=$3
    local disk_info_tmp_file="disk_info.tmp"
    local disk_num=0
    ${PMC_TOOL_ARCCONF} getconfig $cardid pd |sed -n '/Device is a Hard drive/,/Serial number\s*:/p'| grep -v 'Array' > ${disk_info_tmp_file}
    local exist_disk_flag=$(cat ${disk_info_tmp_file} |grep -c "Device is a Hard drive")
    if [ ${exist_disk_flag} -eq 0 ];then
        return 0
    fi
    sed -i '/Device is a Hard drive/i\|' ${disk_info_tmp_file}
    disk_info_string=$(cat ${disk_info_tmp_file})
    OLD_IFS="$IFS"
    IFS="|"
    local disk_info_arr=($disk_info_string)
    
    IFS="$OLD_IFS"
    local arr_length=${#disk_info_arr[@]}
    let disk_num=arr_length-1
    for((i=1;i<=$disk_num;i++))
    do
        local single_disk_info=${disk_info_arr[i]}
        local model_tmp=$(echo "${single_disk_info}" | grep "Model" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        local Firmware=$(echo "${single_disk_info}" | grep "Firmware" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        local serial_num=$(echo "${single_disk_info}" | grep "Serial number" |awk -F: '{print $NF}' |sed -e 's/^[ \t]*//g')
        match_flag=$(echo ${model_tmp} | grep -c ${model})
        if [ $match_flag -ne 0 ];then
            if [ "${Firmware}" = "${newverion}" ];then 
                printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s \n" "harddisk" "SEAGATE"  ${model} "--" ${serial_num} ${Firmware} "--">>seagate_tmp.txt
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-20s %-10s %-16s %-8s %-3s \e[0m\n" "harddisk" "SEAGATE" ${model} "--" ${serial_num} ${Firmware} "--" >>seagate_tmp.txt
            fi
        fi
    done
}

function list_drive_lsi()
{
    local cardid=$1
    local model=$2
    local newverion=$3
    ${LSI_TOOL_STORCLI} /c$cardid /eall /sall show |grep "${model}"> lsi_disk_info.txt
    cat lsi_disk_info.txt |while read line
    do
        local eid=$(echo $line |awk '{print $1}'| awk -F: '{print $1}')
        local slotid=$(echo $line |awk '{print $1}'| awk -F: '{print $2}')
        local firmware_version=$(${LSI_TOOL_STORCLI} /c$cardid /e$eid /s$slotid show all |grep -i "Firmware Revision"|awk '{print $4}')
        if [ "x$firmware_version" = "x$newverion" ];then
            printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s \n" "harddisk" "SEAGATE"  ${model} "--" "--" ${firmware_version} "--">>seagate_tmp.txt
        else
            echo "need update" >>${NEED_UPDATE_FLAG}
            printf "\e[31m%-10s %-10s %-20s %-10s %-16s %-8s %-3s \e[0m\n" "harddisk" "SEAGATE" ${model} "--" "--" ${firmware_version} "--" >>seagate_tmp.txt
        fi
    done
    rm -f lsi_disk_info.txt
}

function listSeagateDrive()
{
    local model=$1
    local configversion=$2
    local fwtype=$3

    if [ "x${fwtype}" = "xbridge" ];then
        return 0
    fi
    echo "scaning seagate disk in server ......"
    echo -e "====================seagate disk model(${model}) info===================== " >>seagate.list
    # pmc
    ${PMC_TOOL_ARCCONF} list > pmc_info_list.txt
    cat pmc_info_list.txt | while read line
    do
        pmc_flag_2100=$(echo $line |grep -c "IOC2100")
        pmc_flag_3100=$(echo $line |grep -c "ROC3100")
        Flag3152_8i=$(echo $line |grep -c "3152-8i")
        Flag3154_16i=$(echo $line |grep -c "3154-16i")
        if [ ${pmc_flag_2100} -ne 0 ] || [ ${pmc_flag_3100} -ne 0 ] || [ ${Flag3152_8i} -ne 0 ] || [ ${Flag3154_16i} -ne 0 ];then
            local cardid=$(echo $line | awk -F ':' '{print $1}'| awk '{print $NF}')
            list_drive_pmc "${cardid}" "${model}" "${configversion}"
        fi
    done
    rm -f pmc_info_list.txt
    # lsi
    ${LSI_TOOL_STORCLI} show | grep "AVAGOMegaRAIDSAS" > lsi_info.txt
    cat lsi_info.txt | while read line
    do
        local flag=$(echo $line | grep -c "AVAGOMegaRAIDSAS")
        if [ $flag -ne 0 ];then
            local lsi_cardid=$(echo $line |sed -e 's/^[ \t]*//g'|awk '{print $1}')
            list_drive_lsi "${lsi_cardid}" "${model}" "${configversion}"
        fi
    done
    rm -f lsi_info.txt
    if [ ! -f "seagate_tmp.txt" ];then
        echo "no seagate disk " >> seagate_tmp.txt
    fi
    local TotalNum=$(cat seagate_tmp.txt| grep "$model"|wc -l)
    printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>seagate.list
    printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s\n"   Device  Verdor  Model FwType SerialNum  FwVer Slot >>seagate.list
    
    cat seagate_tmp.txt | grep "$model" >>seagate.list
    rm -f seagate_tmp.txt
}



##===================================#
# 功能： 希捷硬盘的固件升级
#  入参  $1 : drive model  $2 : fw_file
#       $3 : newVersion
##===================================#
function updateSeagateFW()
{
    local driveModel=$1
    local fullPathFw=$2
    local newVersion=$3
    local fwType=$4
    # pmc卡
    ${PMC_TOOL_ARCCONF} list > pmc_info.txt
    cat pmc_info.txt | while read line
    do
        pmc_flag_2100=$(echo $line |grep -c "IOC2100")
        pmc_flag_3100=$(echo $line |grep -c "ROC3100")
        Flag3152_8i=$(echo $line |grep -c "3152-8i")
        Flag3154_16i=$(echo $line |grep -c "3154-16i")
        if [ ${pmc_flag_2100} -ne 0 ] || [ ${pmc_flag_3100} -ne 0 ] || [ ${Flag3152_8i} -ne 0 ] || [ ${Flag3154_16i} -ne 0 ];then
            local cardid=$(echo $line | awk -F ':' '{print $1}'| awk '{print $NF}')
            ${SCRIPT_PATH}${SEGATE_PMC_ENTRY} "${cardid}" "${driveModel}" "${fullPathFw}" "${newVersion}" "${fwType}" "$PMC_TOOL_ARCCONF"
        fi
    done
    rm -f pmc_info.txt
    # lsi卡
    ${LSI_TOOL_STORCLI} show | grep "AVAGOMegaRAIDSAS" > lsi_info.txt
    cat lsi_info.txt | while read line
    do
        local flag=$(echo $line |grep -c "AVAGOMegaRAIDSAS")
        if [ $flag -ne 0 ];then
            local lsi_cardid=$(echo $line |sed -e 's/^[ \t]*//g'|awk '{print $1}')
            ${SCRIPT_PATH}${SEGATE_LSI_ENTRY} "${lsi_cardid}" "${driveModel}" "${fullPathFw}" "${newVersion}" "${fwType}" "$LSI_TOOL_STORCLI"
        fi
    done
    rm -f lsi_info.txt
}




##===================================#
# 功能： 希捷硬盘的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件     ;$8 升降级比较符
##===================================#
function seagateMain()
{
    
    local diskModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7
    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"
    PMC_TOOL_ARCCONF=${SCRIPT_PATH}"/tools/pmc/"${ARCCONF_NAME}
    # tools/broadcom
    LSI_TOOL_STORCLI=${SCRIPT_PATH}"/tools/broadcom/"${STORCLI_LINUX}
    chmod 755 $PMC_TOOL_ARCCONF
    chmod 755 $LSI_TOOL_STORCLI
    #非配置文件中的参数处理    
    if [ $# -gt `expr ${CFG_FILE_COLUMN_NUM}` ]
    then
        local paraStartPos
        let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
        for moreArgs in ${@:${paraStartPos}}
        do
           case "${moreArgs}" in 
              "list")
              listSeagateDrive "${diskModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
            esac 
       done
   
       return 0
    fi    
    #固件升级
    case "$diskModel" in
        "ST8000NM000A")
            if [ ! -f "${fullPathFw}" -o ! -f "${PMC_TOOL_ARCCONF}" -o ! -f "${LSI_TOOL_STORCLI}" ]
            then
                redFont "${fullPathFw} or ${PMC_TOOL_ARCCONF} or ${LSI_TOOL_STORCLI} dont exist"
                return 0
            fi
            updateSeagateFW "${diskModel}" "${fullPathFw}" "${fwVer}" "${fwType}"
            ;;
        *)
            echo "don't support seagate model :${diskModel} update in new method"
            ;;
    esac
}

seagateMain $@