#!/bin/bash

SCRIPT_PATH=$(dirname $(readlink -f ${BASH_SOURCE[0]}))
#echo $SCRIPT_PATH

#version info
STOR_VERSION=$SCRIPT_PATH"/".."/"version.conf
if [ ! -f ${STOR_VERSION} ]
then
    STOR_VERSION=$SCRIPT_PATH"/"version.conf 
fi

#cmn ·
COMMON_ENTRY="/scripts/cmn/common.sh"

# topo ϢȡĽӿļ
TOPO_ENTRY="${SCRIPT_PATH}/scripts/fw/topo.sh"

#豸
HARD_DISK_ENTRY="/scripts/fw/harddisk.sh"
RAID_CARD_ENTRY="/scripts/fw/raid.sh"
NETWORK_CARD_ENTRY="/scripts/fw/nic.sh"
FC_CARD_ENTRY="/scripts/fw/fc.sh"

#disk fw update scripts
SEGATE_ENTRY="/scripts/fw/seagate.sh"
TOSHIBA_ENTRY="/scripts/fw/toshiba.sh"
WD_ENTRY="/scripts/fw/wd.sh"
SEGATE_USE_LSI_PMC_TOOL_ENTRY="/scripts/fw/seagate_use_lsi_pmc_tool.sh"
SEGATE_PMC_ENTRY="/scripts/fw/seagate_pmc.sh"
SEGATE_LSI_ENTRY="/scripts/fw/seagate_lsi.sh"

SAMSUNG_USE_LSI_PMC_TOOL_ENTRY="/scripts/fw/samsung_use_lsi_pmc_tool.sh"
SAMSUNG_PMC_ENTRY="/scripts/fw/samsung_pmc.sh"
SAMSUNG_LSI_ENTRY="/scripts/fw/samsung_lsi.sh"
SAMSUNG_NVME_ENTRY="/scripts/fw/samsung_nvme.sh"
MICRON_NVME_ENTRY="/scripts/fw/micron_nvme.sh"

#raid hba/lsi card fw update scripts
PMC_CARD_ENTRY="/scripts/fw/pmc82xx.sh"
LSI_CARD_ENTRY="/scripts/fw/lsi.sh"

#network mellanox/intel card fw update scripts
MELLANOX_CARD_ENTRY="/scripts/fw/mellanox.sh"
INTEL_CARD_ENTRY="/scripts/fw/intel.sh"
BROADBOM_CARD_ENTRY="/scripts/fw/nic_broadcom.sh"
NETSWIFT_CARD_ENTRY="/scripts/fw/netswift.sh"

MELLANOX_CARD_MAP=${SCRIPT_PATH}"/""mellanox_map.csv"
INTEL_INFO_MAP=${SCRIPT_PATH}"/""intel_info_map.csv"

#fc qlogic card fw update scripts
QLOGIC_CARD_ENTRY="/scripts/fw/qlogic.sh"

#expander fw update scripts
EXPANDER_ENTRY="/scripts/fw/expander.sh"
GOOXIBM_ENTRY="/scripts/fw/gooxibm.sh"

#firmware ·,/β
FIRMWARE_PATH=$SCRIPT_PATH"/"..
if [ ! -d "${FIRMWARE_PATH}/firmware" ]
then
    FIRMWARE_PATH=$SCRIPT_PATH
fi

#־ļ
HOSTNAME=`hostname`

UPDATE_LOG=${SCRIPT_PATH}"/"fwupdate_${HOSTNAME}.log

UPDATE_SUCCESS_LOG=${SCRIPT_PATH}"/"Success_fwupdate_${HOSTNAME}.log

UPDATE_FAIL_LOG=${SCRIPT_PATH}"/"Fail_fwupdate_${HOSTNAME}.log

NEED_UPDATE_FLAG=${SCRIPT_PATH}"/"needupdate.log

UPDATE_PROCESS_LOG=${SCRIPT_PATH}"/"progress.log

UPDATE_RESULT_LOG=${SCRIPT_PATH}"/"result.log

#ļȫ·
CONFIG_NAME=${SCRIPT_PATH}"/""fw.csv"
TEST_CONFIG_NAME=${SCRIPT_PATH}"/""fwtest.csv"

