#!/bin/bash

#升级fw工具
GOOXIBM_UPDATE_FW_TOOL_SG_NAME="eEPM.sh"
GOOXIBM_UPDATE_FW_TOOL_PMC_NAME="arcconf_linux_update.sh"
##===================================#
# 功能： gooxibm信息查询
# 入参：配置文件 各列
#    $1  model    : 背板类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
# 输出：详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号等信息
##===================================#
function listGooxibmDriveDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "default" ];then
        printf "%-10s %-10s %-12s %-10s %-11s %-8s %-3s\n"   Device  Verdor SgId Model FwType FwVer >>Gooxibm.list
    fi
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do
        ctrlModelNum=$(echo $myline |grep $ctrlModel |wc -l)
        if [ ${ctrlModelNum} -ne 0 ];then
            CtrlId=$(echo $myline | awk '{print $1}')
            if [ ${fwType} = "default" ];then
                local CtrlVer=$(echo $myline | awk '{print $3}')
            fi
            if [ -z $CtrlVer ];then
                CtrlVer='B00'
            fi
            if [ ${CtrlVer} = ${newVer} ];then
                printf "\e[37m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "expander" "GOOXI" ${CtrlId} ${ctrlModel} ${fwType} "${CtrlVer}"  >>Gooxibm.list
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "expander" "GOOXI" ${CtrlId} ${ctrlModel} ${fwType} "${CtrlVer}"  >>Gooxibm.list
            fi
        else
            continue
        fi
    done < $infoFile
    IFS="$OLD_IFS"
}

##===================================#
# 功能： gooxibm固件信息查询
# 入参：配置文件 各列
#     $1  model ：背板类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
# 输出：总数，显示详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号等信息。
##===================================#
function listGooxibmDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3

    if [ ! -f "GooxibmInfo.tmp" ];then
        echo "scaning the gooxibm expander in server......."
        serverR5500G4=$(dmidecode -t baseboard|grep 'Product Name'|grep 'R5500G4'|wc -l)
        if [ ${serverR5500G4} -ne 1 ];then
            return 0
        else
            for model in $(cat /proc/scsi/scsi |grep GOOXI |awk '{print $4}')
			do
				SgId=$(lsscsi -g |grep "${model}" | awk '{print $8}' |awk -F '/' '{print $3}' |sed 's/[a-z]*//g')
				CurrtVersion=$(cat /proc/scsi/scsi |grep "${model}" |awk '{print $7}')
				echo  $SgId  $model  $CurrtVersion                      >>GooxibmInfo.tmp
            done
        fi
        if [ ! -f "GooxibmInfo.tmp" ];then
            echo "no support gooxibm expander fw" >GooxibmInfo.tmp
        fi
    fi

    local TotalNum=`cat GooxibmInfo.tmp  | grep -i $ctrlModel | wc -l`
    if [ $fwType = "default" ];then
        echo -e "====================gooxibm expander model(${ctrlModel}) info===================== " >>Gooxibm.list
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>Gooxibm.list
    fi
    if [ ${TotalNum} -ne 0 ]
    then
        listGooxibmDriveDetails "${ctrlModel}" "GooxibmInfo.tmp" "${newVer}" "$fwType"
    fi
}

##===================================#
# 功能： gooxibm 背板的固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
##===================================#
function GooxibmUpdateCheck()
{
    local gooxibmresult=$1
    local fwType=$2
    local ctrlModel=$3
    local expandernum=$4

    updateNum=$(cat $gooxibmresult| wc -l)
    if [ $updateNum -eq 0 ];then
        return 0
    fi
    defaultFailed=$(cat $gooxibmresult | grep ${ctrlModel} | grep "default update failed" | wc -l)
    defaultSucced=$(cat $gooxibmresult | grep ${ctrlModel} | grep "default update OK" | wc -l)
    if [ $fwType = "default" ];then
        if [ $defaultFailed -eq 0 ];then
            greenFont "total GOOXIBM Expander($ctrlModel) num: $expandernum,default succeed num：$defaultSucced,default failed num：$defaultFailed" | tee -a gooxibm.result
        else
            redFont "total GOOXIBM Expander($ctrlModel) num:$expandernum,default succeed num：$defaultSucced,default failed num：$defaultFailed,please Check!" | tee -a gooxibm.result
            while read myline
            do
                defaultinfo=$(echo $myline | grep default | wc -l)
                if [ defaultinfo != 0 ];then
                   redFont "$myline" | tee -a gooxibm.result
                fi
            done <$gooxibmresult
        fi
    fi
}

##===================================#
# 功能： gooxibm背板的固件升级
# 入参:
#       $1 : expander_model:背板类型
#       $2 : fw_file：待升级固件
#       $3 : newVersion：待升级固件版本信息
#       $4 : fwType：待升级固件类型
##===================================#
function updateGooxibmFW()
{
    local ctrlModel=$1
    local fwFile=$2
    local newVersion=$3
    local fwType=$4
    local GOOXIBM_UPDATE_FW_TOOL_SG=$5
    local GOOXIBM_UPDATE_FW_TOOL_PMC=$6

    if [ ! -f "updategooxibmFW.tmp" ];then
        echo "scaning the gooxibm expander for update in server......." | tee -a ${UPDATE_LOG}
        serverR5500G4=$(dmidecode -t baseboard|grep 'Product Name'|grep 'R5500G4'|wc -l)
        if [ ${serverR5500G4} -ne 1 ];then
           return 0
        else
		    for model in $(cat /proc/scsi/scsi |grep GOOXI |awk '{print $4}');
			do
				SgId=$(lsscsi -g |grep "${model}" |awk '{print $8}' |awk -F"/" '{print $3}' |sed 's/[a-z]*//g')
				CurrtVersion=$(cat /proc/scsi/scsi |grep "${model}" |awk '{print $7}')
				echo  "${SgId}  ${model}  ${CurrtVersion} "  >> updategooxibmFW.tmp
            done
        fi
        if [ ! -f "updategooxibmFW.tmp" ];then
            echo "no support expander fw" >updategooxibmFW.tmp
        fi
    fi

    local GooxibmContrlNum=$(cat updategooxibmFW.tmp  | grep -i $ctrlModel | wc -l)

    if [ ${GooxibmContrlNum} -eq 0 ]
    then 
        echo -e "Total gooxibm expander(${ctrlModel}) num: 0,success num : 0" |tee -a gooxibm.result
        greenFont "no gooxibm expander (${ctrlModel}) in this server,no need to update" |tee -a gooxibm.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no expander"
        return 0
    fi
    while read myline
    do
		ctrlModelNum=$(echo $myline |grep $ctrlModel |wc -l)
		if [ ${ctrlModelNum} -ne 0 ];then
            starttime=`date +'%Y-%m-%d %H:%M:%S'`
            start_seconds=$(date --date="$starttime" +%s)
			CtrlId=$(echo $myline | awk  '{print $1}')
			CtrlVer=$(echo $myline | awk  '{print $3}')
			if [ -z $CtrlVer ];then
				CtrlVer="B00"
			fi

			if [ ${CtrlVer} = ${newVersion} ];then 
				greenFont "gooxibm expander(${ctrlModel}) $CtrlId $fwType is new version(${newVersion}) in this server,no need to update " |tee -a gooxibm.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $CtrlId $fwType "success" $CtrlVer $newVersion $updatetime
				continue
			else
				if [ ${fwType} = "default" ];then
					ret=`arcconf-linux list |grep "Controllers found" |awk '{print$3}'`
					if [ ${ret} -eq 0 ];then  #no pmc controller
						updatestatus=`$GOOXIBM_UPDATE_FW_TOOL_SG ${CtrlId} ${fwFile}`
						if [ $? -eq 0 ];then
							echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK" >>gooxibmresult.tmp
							echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK"
						else
							echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!" >>gooxibmresult.tmp
							echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!"
						fi
					else
						controllerid=`arcconf-linux list |grep Controller | sed '1,3d'|awk '{print$2}'|awk -F: '{print$1}'`
						expandernum=$(arcconf-linux expanderlist $controllerid |grep "Expander#" |wc -l)
						if [ $expandernum -eq 2 ];then
							connectorID=($(arcconf-linux expanderlist $controllerid |grep "Reported Location" |awk '{print $5}'|awk -F, '{print $1}'))
							Channel_Device=($(arcconf-linux expanderlist $controllerid |grep "Reported Channel,Device"|awk '{print$4}'))
							for ((i=0;i<${#connectorID[@]};i++));do
								ChannelID=$(echo ${Channel_Device[i]}| awk -F, '{print$1}')
								DeviceID=$(echo ${Channel_Device[i]} | awk -F, '{print$2}')
								result_check=`arcconf-linux getconfig $controllerid pd $ChannelID $DeviceID | grep $ctrlModel`
								if [ $? -ne 0 ];then
									continue
								else
									echo "connectorID:${connectorID[i]},channekID:${ChannelID},deviceID:${DeviceID},fwfile:${fwFile}"
									updatestatus=`$GOOXIBM_UPDATE_FW_TOOL_PMC ${controllerid} ${connectorID[i]} ${ChannelID} ${DeviceID} ${fwFile}`
									if [ $? -eq 0 ];then
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK" >>gooxibmresult.tmp
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK"
									else
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!" >>gooxibmresult.tmp
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!"
									fi
									break
								fi
							done
						fi
						if [ $expandernum -eq 1 ];then
							connectorID=$(arcconf-linux expanderlist $controllerid |grep "Reported Location" |awk '{print $5}'|awk -F, '{print $1}')
							Channel_Device=$(arcconf-linux expanderlist $controllerid |grep "Reported Channel,Device"|awk '{print$4}')
							ChannelID=$(echo ${Channel_Device}| awk -F, '{print$1}')
							DeviceID=$(echo ${Channel_Device} | awk -F, '{print$2}')
							result_check=`arcconf-linux getconfig $controllerid pd $ChannelID $DeviceID | grep $ctrlModel`
								if [ $? -ne 0 ];then
									updatestatus=`$GOOXIBM_UPDATE_FW_TOOL_SG ${CtrlId} ${fwFile}`
									if [ $? -eq 0 ];then
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK" >>gooxibmresult.tmp
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK"
									else
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!" >>gooxibmresult.tmp
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!"
									fi
								else
									echo "connectorID:${connectorID},channekID:${ChannelID},deviceID:${DeviceID},fwfile:${fwFile}"
									updatestatus=`$GOOXIBM_UPDATE_FW_TOOL_PMC ${controllerid} ${connectorID} ${ChannelID} ${DeviceID} ${fwFile}`
									if [ $? -eq 0 ];then
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK" >>gooxibmresult.tmp
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK"
									else
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!" >>gooxibmresult.tmp
										echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!"
									fi
								fi
						fi
						if [ $expandernum -eq 0 ];then
							updatestatus=`$GOOXIBM_UPDATE_FW_TOOL_SG ${CtrlId} ${fwFile}`
							if [ $? -eq 0 ];then
								echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK" >>gooxibmresult.tmp
								echo "gooxibm expander($ctrlModel) $CtrlId $fwType update OK"
							else
								echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!" >>gooxibmresult.tmp
								echo "gooxibm expander($ctrlModel) $CtrlId $fwType update failed,please Check!"
							fi
						fi
					fi
                    updatestatus=$(cat "gooxibmresult.tmp"|grep -c "please Check")
                    if [ 0 -eq $updatestatus ];then
                        result="success"
                    else
                        result="failed"
                    fi
                    endtime=`date +'%Y-%m-%d %H:%M:%S'`
                    end_seconds=$(date --date="$endtime" +%s)
                    updatetime=$((end_seconds-start_seconds))
                    updateResult $ctrlModel $CtrlId $fwType $result $CtrlVer $newVersion $updatetime
				fi
			fi
		fi
	done < updategooxibmFW.tmp
    
	if [ -f "gooxibmresult.tmp" ];then
        GooxibmUpdateCheck "gooxibmresult.tmp" "$fwType" "$ctrlModel" "$GooxibmContrlNum"
        rm -rf "gooxibmresult.tmp"
    fi
}

##===================================#
# 功能： gooxibm的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件
##===================================#
function gooxibmMain()
{

    local deviceType=$1
    local vendorType=$2
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"
    GOOXIBM_UPDATE_FW_TOOL_SG=${SCRIPT_PATH}"/"${fwToolsDir}"/sg_tool/"${GOOXIBM_UPDATE_FW_TOOL_SG_NAME}
    GOOXIBM_UPDATE_FW_TOOL_PMC=${SCRIPT_PATH}"/"${fwToolsDir}"/pmc_tool/"${GOOXIBM_UPDATE_FW_TOOL_PMC_NAME}
    if [ ! -f "${GOOXIBM_UPDATE_FW_TOOL_SG}" -o ! -f "${fullPathFw}" ]
    then
        redFont "${GOOXIBM_UPDATE_FW_TOOL_SG} or ${fullPathFw} dont exist"
        return 0
    fi
    if [ ! -f "${GOOXIBM_UPDATE_FW_TOOL_PMC}" ]
    then
        redFont "${GOOXIBM_UPDATE_FW_TOOL_PMC} dont exist"
        return 0
    fi

    chmod 755 ${GOOXIBM_UPDATE_FW_TOOL_SG}
    chmod 755 ${GOOXIBM_UPDATE_FW_TOOL_PMC}

    #非配置文件中的参数处理
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in
             "list")
              listGooxibmDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *)
              echo "no implement function :${moreArgs}"
              ;;
          esac
       done

       return 0
    fi

    #固件升级
    case "$contrlModel" in
    "2U12SXP"|"4U24SXP")
        if [ $deviceType = "expander" -a $vendorType = "GOOXI" ];then
            updateGooxibmFW "${contrlModel}" "${fullPathFw}" "${fwVer}" "${fwType}" "${GOOXIBM_UPDATE_FW_TOOL_SG}" "${GOOXIBM_UPDATE_FW_TOOL_PMC}"
			echo "updateGooxibmfw***model=${contrlModel}"
        else
            echo "don't support $deviceType or $vendorType"
        fi
        ;;
      *)
        echo "don't support GOOXIBM expander model :${contrlModel}" 
        ;;
    esac
}

gooxibmMain $@