#!/bin/bash

SAS3IRCU="sas3ircu-linux"
STORCLI="storcli-linux"

BROADCOM_PATH=${SCRIPT_PATH}/tools/broadcom/

SAS3IRCU_TOOL=${BROADCOM_PATH}/${SAS3IRCU}
STORCLI_TOOL=${BROADCOM_PATH}/${STORCLI}

chmod 777 ${SAS3IRCU_TOOL}
chmod 777 ${STORCLI_TOOL}

#topo 文件
SAS_TOPO="sas_topo.tmp"
#topo文件内容示例如下
# type id  eid  slot  sn 
#9361  0  252 1  WNB00716
#9361  0  252 3  WNB006BZ
#9361  0  252 7  WNB006JX
#9361  0  252 9  WNB006XV
#9361  0  252 10  WNB006PS
#9361  0  252 11  WFK4JZDD0000K001NRB0
#3008  0   2  4  WBM1B7EF
#3008  0   2  5  WBN00EQW
#3008  0   2  11  WFJ042J0


MRCARD="MRcard.tmp"
DRIVESINMR="MRDrives.tmp"
PDSINFOINMR="pdsinfoMR.tmp"
ONEPDINMR="onepdinfoMR.tmp"

#=========================================================#
#功能： 列出环境中mr卡的下的磁盘 拓扑及sn
# 入参：$1 为卡的类型，示例 9361 9341等

#每个磁盘的属性如下
#Drive /c0/e252/s11 Device attributes :
#====================================
#SN = WFK4JZDD0000K001NRB0
#Manufacturer Id = SEAGATE
#Model Number = ST1200MM0129
#NAND Vendor = NA
#WWN = 5000C500C2326FDC
#Firmware Revision = C004
#Firmware Release Number = N/A
#Raw size = 1.090 TB [0x8bba0cb0 Sectors]
#Coerced size = 1.089 TB [0x8b94f800 Sectors]
#Non Coerced size = 1.090 TB [0x8baa0cb0 Sectors]
#Device Speed = 12.0Gb/s
#Link Speed = 12.0Gb/s
#Write Cache = N/A
#Logical Sector Size = 512B
#Physical Sector Size = 4 KB
#Connector Name = Port 8 - 11 x1
#=========================================================#
function listMrTopo()
{
    local cardType=$1;
    
    # 列出环境中 参数1 类型的卡，输出到文件示例为
    #0 AVAGOMegaRAIDSAS9361-16i    16   6   2     2   2     2 N/A On  -  Y      3 NdAtn

    ${STORCLI_TOOL} show |grep "${cardType}" >${MRCARD}
    
    if [ -s "${MRCARD}" ]   # 文件内容不为空，则说明存在此种类型的卡
    then 
        local mrCtrlIds=`cat ${MRCARD} |awk '{print $1}'` #取出此类型卡的控制器编号到数组中
        #遍历每个控制器
        for mrCtrlId in ${mrCtrlIds[@]}
        do
           #针对每个控制器列出其所有磁盘的信息
           echo "${cardType} id ${mrCtrlId}"
           ${STORCLI_TOOL} /c${mrCtrlId}/eall/sall show all >${DRIVESINMR}
           
           #将每次磁盘的详细信息取出,每个磁盘的属性参见 函数注释
           sed -n '/Device attributes/,/Connector Name /p' ${DRIVESINMR} >${PDSINFOINMR}
           local DiskNum=`sed -n '/Device attributes/p' ${PDSINFOINMR} | wc -l`
           # 处理每个磁盘的属性。 其中18p 18d中的18表示每个磁盘属性占用18行。即每次取出18行（一个磁盘信息）
           for((i=1;i<=$DiskNum;i++))
           do
                sed -n '1,18p' ${PDSINFOINMR} > ${ONEPDINMR}
                local EID=`cat ${ONEPDINMR} |awk -F "/" '{print $3}'`
                local Slot=`cat ${ONEPDINMR} |awk -F "/" '{print $4}'|awk '{print $1}'`
                local SN=`cat ${ONEPDINMR} |grep "SN =" |awk -F "=" '{print $2}'`
                
                EID=${EID:1}  #原始数据带有e字母，例如e2， 去除字母e
                Slot=${Slot:1} #原始数据带有s字母，例如s12， 去除字母s
                
                echo  "${cardType}  ${mrCtrlId}  ${EID} ${Slot} ${SN}" >>${SAS_TOPO}                
                #从文件中删除处理完的第一个磁盘信息。
                sed -i '1,18d' ${PDSINFOINMR}
            done
           
       done #end  遍历每个控制器
    else
       echo "no ${cardType} card in this server"
    fi
}



HBA3008CARD="hba3008Card.tmp"
DRIVESINHBA3008="hba3008Drives.tmp"
PDSINFOINHBA3008="pdsinfo3008.tmp"
ONEPDINHBA3008="onepdinfo.tmp"

#=======================================================#
# 功能：列出ir卡的拓扑信息
# 入参：$1　表示卡的类型，比如3008等，要在sas3ircu
#
#每个磁盘的属性如下
#Device is a Hard disk
#  Enclosure #                             : 2
#  Slot #                                  : 11
#  PI Supported                            : No
#  SAS Address                             : 5000c50-0-a124-83a5
#  State                                   : Ready (RDY)
#  Size (in MB)/(in sectors)               : 572325/1172123567
#  Manufacturer                            : SEAGATE
#  Model Number                            : ST600MM0099
#  Firmware Revision                       : C003
#  Serial No                               : WFJ042J0
#  Unit Serial No(VPD)                     : WFJ042J00000E81644AS
#  GUID                                    : 5000c500a12483a7
# Protocol                                : SAS
#  Drive Type                              : SAS_HDD
#  2020-04-17  先找出一个盘开始，结束的位置，再取得一个盘占用的行数:即
#  结束-开始+1  再加一个空行+1
#=======================================================#

function listIrTopo()
{
    local cardType=$1
    ${SAS3IRCU_TOOL} list |grep ${cardType} > ${HBA3008CARD}
    
    if [ -s "${HBA3008CARD}" ]   # 文件内容不为空,,则进行处理
    then 
        local ctrlIds=`cat ${HBA3008CARD} |awk '{print $1}' `
        for ctrlId in ${ctrlIds[@]}
        do            
            ${SAS3IRCU_TOOL} ${ctrlId} display >${DRIVESINHBA3008}
            sed -n '/Device is a Hard disk/,/-----------------------/p' ${DRIVESINHBA3008} > ${PDSINFOINHBA3008}
            sed -i '/-----------------------/d' ${PDSINFOINHBA3008}
            local firstDrivePosEnd=`grep -n -i  "Drive type"  ${PDSINFOINHBA3008} | head -1|awk -F ":" '{print $1}'`
            local firstDrivePosBegin=`grep -n -i  "Device is a Hard disk"  ${PDSINFOINHBA3008} | head -1|awk -F ":" '{print $1}'`
            local diskInfoLineNums
            let diskInfoLineNums=$firstDrivePosEnd-$firstDrivePosBegin+1+1
            echo "3008 id :${ctrlId} drivelines:$diskInfoLineNums"
            local DiskNum=`sed -n '/Device is a Hard disk/p' ${PDSINFOINHBA3008} | wc -l`
            for((i=1;i<=$DiskNum;i++))
            do
                sed -n '1,'$diskInfoLineNums'p' ${PDSINFOINHBA3008} > ${ONEPDINHBA3008}
                local EID=`cat ${ONEPDINHBA3008} |grep Enclosure |awk -F ":" '{print $2}'`
                local Slot=`cat ${ONEPDINHBA3008} |grep Slot |awk -F ":" '{print $2}'`
                local SN=`cat ${ONEPDINHBA3008} |grep "Serial No " |awk -F ":" '{print $2}'`
                echo  "3008  ${ctrlId}  ${EID} ${Slot} ${SN}" >>${SAS_TOPO}
                #echo "3008  ${ctrlId}  ${EID} ${Slot} ${SN}"
                sed -i '1,'$diskInfoLineNums'd' ${PDSINFOINHBA3008}
            done
        done
    else
       echo "no ${cardType} card in this server"
    fi   
    
}



function listTopo()
{ 
   listMrTopo "9361"
   listMrTopo "9341"
   listIrTopo "3008" 
}





