#!/bin/bash
#升级fw工具
NVME_TOOL_NAME="nvme"

##===================================#
# 功能： WD disk信息查询
# 入参：配置文件 各列
#    $1  model    : 控制卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
#    $4  updateFlag   ：升降级比较符
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息
##===================================#
function listWdNvmediskDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "default" ];then
        printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s\n"   Device  Verdor  Model FwType SerialNum  FwVer Slot >>wd_nvme.list
    fi
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do 
        local flag=$(echo ${myline} |grep -c "${ctrlModel}")
        if [ ${flag} -ne 0 ];then
            local FW_Rev=$(echo ${myline} |awk '{print $NF}')
            if [ "${FW_Rev}" != "${newVer}" ];then 
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-20s %-10s %-16s %-8s %-3s \e[0m\n" "harddisk" "WD" ${ctrlModel} ${fwType} "--"  "${FW_Rev}" "--"  >>wd_nvme.list
            else
                printf "%-10s %-10s %-20s %-10s %-16s %-8s %-3s \n" "harddisk" "WD" ${ctrlModel} ${fwType} "--" "${FW_Rev}" "--"  >>wd_nvme.list
            fi
        fi
    done < $infoFile
    IFS="$OLD_IFS"
}

##===================================#
# 功能： WD disk固件信息查询
# 入参：配置文件 各列
#     $1  ctrlModel ：控制器类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
#     $4  updateFlag: 升降级比较符
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息。
##===================================#
function listwdDiskDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3

    if [ ! -f "WD_nvme_disk.tmp" ]
    then
        echo "scaning the wd nvme disk in server......."
        ${WD_NVME_TOOL} list | grep "/dev/nvme" >WD_nvme_disk.tmp
    fi

    local TotalNum=`cat WD_nvme_disk.tmp | grep $ctrlModel | wc -l`

    if [ $fwType = "default" ];then
        echo -e "====================WD nvme disk model(${ctrlModel}) info===================== " >>wd_nvme.list
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>wd_nvme.list
    fi
    if [ ${TotalNum} -ne 0 ]
    then
        listWdNvmediskDetails "${ctrlModel}" "WD_nvme_disk.tmp" "${newVer}" "$fwType"
    fi

}
##===================================#
# 功能： WD disk固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
#       $3 : 待升级硬盘个数
##===================================#
function wdNvmeUpdateCheck()
{
    local wdNvmeresult=$1
    local fwType=$2
    local wdNum=$3
    local ctrlModel=$4
    local newVersion=$5
    local updatetime=$6

    fwSucced=$(cat $wdNvmeresult | grep "default update OK" | wc -l)

    if [ $fwType = "default" ];then
        if [ $fwSucced -eq $wdNum ];then
            greenFont "total harddisk($ctrlModel) need update num:$wdNum,fw succeed num：$fwSucced" | tee -a wd_nvme.result
            updateResult $ctrlModel "all" "${fwtype}" "success" "--" $newVersion $updatetime
        else
            redFont "total harddisk($ctrlModel) need update num:$wdNum,fw succeed num：$fwSucced,please Check!" | tee -a wd_nvme.result
            updateResult $ctrlModel "all" "${fwtype}" "failed" "--" $newVersion $updatetime
        fi
    fi
}

##===================================#
# 功能： WD disk的固件升级
# 入参:
#       $1 : ctrlModel:硬盘类型
#       $2 : fw_file：待升级固件
#       $3 : newVersion：待升级固件版本信息
#       $4 : fwType：待升级固件类型
##===================================#
function updateWDdiskFW()
{
    local ctrlModel=$1
    local fwFile=$2
    local newVersion=$3
    local fwType=$4
    rm -f "update_nvme_disk_info.tmp"
    chmod +x ${WD_NVME_TOOL}
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    ${WD_NVME_TOOL} list | grep "/dev/nvme" >total_nvme_disk_info.tmp
    while read line
    do
        flag=$(echo ${line} |grep -c "${ctrlModel}")
        if [ $flag -ne 0 ];then
            local Node=$(echo ${line}|awk '{print $1}')
            local FW_Rev=$(echo ${line}|awk '{print $NF}')
            echo "${ctrlModel}" "${Node}" "${FW_Rev}" >> update_nvme_disk_info.tmp
        fi
    done < total_nvme_disk_info.tmp
    
    if [ ! -f "update_nvme_disk_info.tmp" ]
    then
        echo -e "Total harddisk (${ctrlModel}) num: 0,success num : 0" |tee -a wd_nvme.result
        greenFont "no harddisk (${ctrlModel}) in this server,no need to update" |tee -a wd_nvme.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no disk"
        return 0
    fi
    
    total_num=$(cat update_nvme_disk_info.tmp|grep -c "${ctrlModel}")
    local already_new=0
    local need_update_num=0
    while read myline
    do 
        local Node=$(echo ${myline} | awk '{print $2}')
        local FW_Rev=$(echo ${myline} | awk '{print $3}')
        if [ ${fwType} = "default" ];then
            if [ ${FW_Rev} = "${newVersion}" ];then
                let already_new=already_new+1
            else
                let need_update_num=need_update_num+1
                ${WD_NVME_TOOL} fw-download ${Node} -f ${fwFile}
                if [ $? -ne 0 ];then
                    echo "harddisk($ctrlModel) $fwType update failed,please Check!" >>wd_nvme.tmp
                else
                    ${WD_NVME_TOOL} fw-commit ${Node} -a 3 -s 0
                    if [ $? -ne 0 ];then
                        echo "harddisk($ctrlModel) $fwType update failed,please Check!" >>wd_nvme.tmp
                    else
                        echo "harddisk($ctrlModel) $fwType update OK" >>wd_nvme.tmp
                    fi
                fi
            fi
        fi
    done < update_nvme_disk_info.tmp
    let need_update_num=total_num-already_new
    if [ ${need_update_num} -eq 0 ];then
        endtime=`date +'%Y-%m-%d %H:%M:%S'`
        end_seconds=$(date --date="$endtime" +%s)
        updatetime=$((end_seconds-start_seconds))
        greenFont "all harddisk(${ctrlModel}) $fwType is new version(${newVersion}) in this server,no need to update " |tee -a wd_nvme.result
        updateResult $ctrlModel "all" "$fwType" "success" $newVersion $newVersion $updatetime
        return 0
    fi
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ -f "wd_nvme.tmp" ];then
        wdNvmeUpdateCheck "wd_nvme.tmp" "$fwType" "$need_update_num" "$ctrlModel" "$newVersion" "$updatetime"
        rm -f "wd_nvme.tmp"
    fi
    
 
}


##===================================#
# 功能： wd disk的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件     ;
##===================================#
function WDdiskMain()
{
    
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7
    local deviceType=$1
    local vendorType=$2

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"  

    WD_NVME_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${NVME_TOOL_NAME}

    if [ ! -f "${WD_NVME_TOOL}" -o ! -f "${fullPathFw}" ]
    then
        redFont " ${WD_NVME_TOOL} or ${fullPathFw} dont exist"
        return 0
    fi
    
    #非配置文件中的参数处理    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then 
    
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listwdDiskDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    #固件升级
    case "$contrlModel" in 
    "WUS4BA119DSP3X1"|"WUS4BA138DSP3X1"|"WUS4BA176DSP3X1"|"WUS4C6416DSP3X1"|"WUS4C6432DSP3X1")
        if [ $deviceType = "harddisk" -a $vendorType = "WD" ];then
            updateWDdiskFW "${contrlModel}" "${fullPathFw}" "${fwVer}" "${fwType}"
        else
            echo "don't support $deviceType or $vendorType"
        fi
        ;;
      *)
        echo "don't support pmc raid card model :${contrlModel}" 
        ;;
    esac
}
WDdiskMain $@
