#!/bin/bash
ORA_PATH=`pwd`
LOCAL_COMMON_ENTRY=$ORA_PATH"/scripts/cmn/common.sh"
PATHCFG_ENTRY=$ORA_PATH"/""pathcfg.sh"
BROADCOM_RESULT_FILE=$ORA_PATH"/""broadcomresult.tmp"
BROADCOM_RESULT_FILE_FINAL=$ORA_PATH"/""broadcom.result"


##===================================#
# 功能： BROADCOM 网卡的固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
#       $3 : 卡类型
#       目录博通ocp卡只能安装一张，博通网卡比较特殊，需要设置的配置项较多（不同用户定制的也不一样），不好做成通用固件升级
##===================================#
function broadcomUpdateCheck()
{
    local broadcom_result=$1
    echo "broadcom_result:$broadcom_result"
    local fwType=$2
    local ctrlModel=$3
    defaultFailed=$(cat $broadcom_result | grep ${ctrlModel} | grep "default update failed" | wc -l)
    defaultSucced=$(cat $broadcom_result | grep ${ctrlModel} | grep "default update OK" | wc -l)
    package_id_failed=$(cat $broadcom_result | grep ${ctrlModel} | grep "package_id modify failed" | wc -l)
    package_id_success=$(cat $broadcom_result | grep ${ctrlModel} | grep "package_id modify OK" | wc -l)
    if [ $fwType = "default" ];then
        if [ $defaultFailed -eq 0 ] && [ $package_id_failed -eq 0 ];then
            greenFont "total broadcom card($ctrlModel) num:$BroadcomNum,fw succeed num：$defaultSucced,modify package_id succeed num:$package_id_success,fw failed num：$defaultFailed,modify package_id failed num:$package_id_failed" | tee -a $BROADCOM_RESULT_FILE_FINAL
        else
            redFont "total broadcom card($ctrlModel) num:$BroadcomNum,fw succeed num：$defaultSucced,modify package_id succeed num:$package_id_success,fw failed num：$defaultFailed,modify package_id failed num:$package_id_failed,please Check!" | tee -a $BROADCOM_RESULT_FILE_FINAL
            redFont "suggest to try to update once more!" | tee -a $BROADCOM_RESULT_FILE_FINAL
            while read myline
            do
                defaultinfo=$(echo $myline | grep default | wc -l)
                if [ defaultinfo != 0 ];then
                   redFont "$myline" | tee -a $BROADCOM_RESULT_FILE_FINAL
                fi
            done <$broadcom_result
        fi
    fi
}

#博通网卡修改package_id
function modify_package_id()
{
    cd ./bnxtmt/CMB_A
    version=$(find ./ -name *.tar.gz |awk -F- '{print $2}')
    cd ./bnxtmt-$version-x86_64
    source $LOCAL_COMMON_ENTRY
    rmmod bnxt_en > /dev/null 2>&1
    rmmod bnxtmtdrv > /dev/null 2>&1
    rmmod bnxt_re > /dev/null 2>&1
    chmod +x ./load.sh
    ./load.sh <<- EOF
	fwutil
	nvm cfg 256=0
	nvm cfg 261=29
	nvm cfg 262=30
	nvm cfg 263=128
	exit
	EOF
    if [ $? -eq 0 ];then
        echo "broadcom nic card($model) -- package_id modify OK" >>$BROADCOM_RESULT_FILE
        updateResult $model "--" "package_id" "success" "--" "--" $updatetime
    else
        echo "broadcom nic card($model) NA package_id modify failed" >>$BROADCOM_RESULT_FILE
        updateResult $model "--" "package_id" "failed" "--" "--" $updatetime
    fi
}

#博通网卡升级的main
#    $1:model:网卡型号
#    $2:package_path:固件包路径
#    固件名称统一为：固件型号.tar.gz
function main()
{
    local package_path=$2
    model=$1
    BroadcomNum=$3
    cd ${package_path}
    if [ ! -f "${model}.tar.gz" ];then
        echo "package:${model}.tar.gz not exit,please check"
        exit -1
    fi
    starttime=`date +'%Y-%m-%d %H:%M:%S'`
    start_seconds=$(date --date="$starttime" +%s)
    tar zxf ${model}.tar.gz >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "tar package:${model}.tar.gz failed please try again"
        exit -1
    fi
    chmod +x -R ./${model}
    cd ${model}
    source $PATHCFG_ENTRY
    source $LOCAL_COMMON_ENTRY
    ./install.sh
    endtime=`date +'%Y-%m-%d %H:%M:%S'`
    end_seconds=$(date --date="$endtime" +%s)
    updatetime=$((end_seconds-start_seconds))
    if [ $? -eq 0 ];then
        echo "broadcom nic card($model) -- default update OK" >>$BROADCOM_RESULT_FILE
        updateResult $model "--" "default" "success" "--" "--" $updatetime
    else
        echo "broadcom nic card($model) -- default update failed" >>$BROADCOM_RESULT_FILE
        updateResult $model "--" "default" "failed" "--" "--" $updatetime
    fi
    modify_package_id
    if [ -f "$BROADCOM_RESULT_FILE" ];then
        broadcomUpdateCheck "$BROADCOM_RESULT_FILE" "default" "$model"
    fi
}

main $@