#!/bin/sh

# This script should be executed in post section of the RPM
# or just after installing the libiscsi.so.#
# This will create the necessary symbolick links.
#
# Background:
# To ensure correct version of libiscsi is installed the libiscsi.so will
# carry the version number in its name,for example libiscsi.so.0
# Now the applicaiton installing libiscsi.so.0 need to ensure that a symbolic
# link is created wihtout the version name as other applications link to the
# libraries having version less name.
# ildapi.so links to libiscsi.so
# libiscsi.so would be a symlink to libiscs.so.<version number>
# Example:
# lrwxrwxrwx. 1 root root       13 Aug 23 16:05 libiscsi.so -> libiscsi.so.0
# -rwxr-xr-x. 1 root root  1130452 Aug 23 14:17 libiscsi.so.0

RHEL_LIB_CLI="/opt/QLogic_Corporation/QConvergeConsoleCLI/redhat/"
SUSE_LIB_CLI="/opt/QLogic_Corporation/QConvergeConsoleCLI/suse/"
LINK_NAME="libiscsi.so"

CUR_DIR=`pwd`

#create links from CLI  folder
if [ -d ${RHEL_LIB_CLI} ]; then
	RHEL_LIB_VER_CLI=`ls ${RHEL_LIB_CLI} | grep -m 1 "libiscsi\.so\..*"`
	cd ${RHEL_LIB_CLI}
	if [ ! -f $LINK_NAME ]; then
		if [ -f ${RHEL_LIB_VER_CLI} ]; then
		ln -s ${RHEL_LIB_VER_CLI} ${LINK_NAME}
		fi
	fi
fi

if [ -d ${SUSE_LIB_CLI} ]; then
	SUSE_LIB_VER_CLI=`ls ${SUSE_LIB_CLI} | grep -m 1 "libiscsi\.so\..*"`
	cd ${SUSE_LIB_CLI}
	if [ ! -f $LINK_NAME ]; then
		if [ -f ${SUSE_LIB_VER_CLI} ]; then
			ln -s ${SUSE_LIB_VER_CLI} ${LINK_NAME}
		fi
	fi
fi

cd ${CUR_DIR}
