import os
import sys
sys.path.append("/usr/lib/python3.7/sist-packages")
sys.path.append("/usr/lib/python3.7/lib-dynload")
sys.path.append("/usr/bin/cmn")
from cmn import Recordloger

selected_fw_dict = eval(sys.argv[1])
# selected_fw_dict = {'ST1200MM0129': 'C004', 'ST2400MM0129': 'C004', 'ST1800MM0129': 'C004',
# 'SDLSA(SAS3008)': '16.00.00.00_14.01.00.01'}

FWALL_CSV = '/usr/bin/FwUpdate/linux/fwall.csv'
FW_CSV = '/usr/bin/FwUpdate/linux/fw.csv'
FWUPDATE_SCRIPT = '/usr/bin/FwUpdate/fwUpdate.py'
RESULT_LOG = '/usr/bin/FwUpdate/linux/result.log'
FILE_TMP_RESULT_LOG = "/tmp/tmp.log"

logger, filehandler = Recordloger("Result", FILE_TMP_RESULT_LOG)

if os.path.exists(FWALL_CSV):
    fwall_csv_info = open(FWALL_CSV, 'r', encoding='gbk')
    total_items = fwall_csv_info.readlines()
    for i in range(len(total_items)):
        total_items[i] = total_items[i].replace(' ', '').split(',')

result_log = open(RESULT_LOG, 'w+')
result_log.truncate()
selected_fw_pakage_list = []
for type, version in selected_fw_dict.items():
    for item in total_items:
        if item[0][0] != '#' and (item[4] == 'default' or item[4] == 'fw'):
            if type == item[2] and version == item[5]:
                selected_fw_pakage_list.append([item[2], item[3]])
                break
    else:
        result_log.write("%s,--,fw,failed,--,%s,0,no such deviece or version\n" % (type, version))
        print("Can not match %s version %s" % (type, version))
        logger.info("Can not match: %s version: %s, Please Confirm!!" % (type, version))
result_log.close()

fw = open(FW_CSV, 'w+')
fw.truncate()
fw.write('#设备, 厂商, 型号, 固件类型, 固件版本号, 固件工具路径, 固件版本文件')
fw.write('\n')
for pakage in selected_fw_pakage_list:
    for item in total_items:
        # 固件版本号为'-'的不是固件，不需要写入fw.csv
        if pakage[0] == item[2] and pakage[1] == item[3] and item[5] != "-":
            del item[3]
            fw.write(','.join(item))
fw.close()

os.system("python3.7 %s" % FWUPDATE_SCRIPT)

logger.removeHandler(filehandler)
