import os

RESULT_LOG = "/usr/bin/FwUpdate/linux/result.log"
FINAL_RESULT_LOG = "/usr/bin/FwUpdate/linux/final_result.log"


def read_log_info():
    result_list = []
    with open(RESULT_LOG, 'r') as f:
        filecontent = f.readlines()
        for result in filecontent:
            result_list.append(result.strip('\n').split(","))
        for result in result_list:
            result[6] = int(result[6])
    f.close()
    return result_list


def sort(result_list):
    for result in result_list:
        if result[2] == "fw" or result[2] == "default":
            result[2] = "1" + "fw"
    result_list.sort()
    for result in result_list:
        result[2] = result[2].lstrip("1")
    result_list.reverse()
    return result_list


def analyse_result(result_list):  # noqa: C901
    len_result_list = len(result_list)
    if len_result_list == 1:
        if result_list[0][7] == "":
            result_list[0][7] = "--"
    elif len_result_list > 1:
        for i in range(len_result_list):
            # [device,id,fwtype,result,currVer,targetResult,updatetime,detail]
            # ['9460-8i', '0', 'fw', 'success', '5.130.00-3059', '5.130.00-3059', 0, '']
            if i < len_result_list - 1 and result_list[i] == result_list[i + 1]:
                result_list[i] = []
            elif result_list[i][2] == "fw" or result_list[i][2] == "default":
                if result_list[i][7] == "":
                    result_list[i][7] = "--"
            else:
                result_list[i + 1][6] = result_list[i][6] + result_list[i + 1][6]
                if result_list[i][3] == "failed":
                    result_list[i + 1][3] = "failed"
                if result_list[i][7] != "":
                    result_list[i + 1][7] = result_list[i][7] + ";" + result_list[i + 1][7]
                result_list[i] = []
    while [] in result_list:
        result_list.remove([])
    return result_list


def convert_format_result(result_list):
    final_result_dict = {}
    final_result_list = []
    for result in result_list:
        result_dict = {}
        result_dict["card_type"] = result[0]
        result_dict["card_id"] = result[1]
        result_dict["cur_fw_version"] = result[4]
        result_dict["update_fw_version"] = result[5]
        result_dict["update_interval"] = result[6]
        result_dict["update_result"] = result[3]
        result_dict["detail"] = result[7]
        final_result_list.append(result_dict)
    final_result_dict["result"] = final_result_list
    return final_result_dict


def record_log(final_result):
    result_log = open(FINAL_RESULT_LOG, 'w+')
    result_log.truncate()
    result_log.write(str(final_result).replace("'", "\""))
    result_log.close()


if __name__ == "__main__":
    if os.path.exists(RESULT_LOG):
        result_list = read_log_info()
        result_list = sort(result_list)
        result_list = analyse_result(result_list)
        final_result = convert_format_result(result_list)
        record_log(final_result)
