#!/bin/bash



##=========================================
#  : ʽ ַ  :ɫʾ
#  Σ$1 Ϊ ʽַ
##========================================

function greenFont()
{
    echo -e "\033[32m[ $1 ]\033[0m"
}
##=========================================
#  : ʽ ַ  :ɫʾ
#  Σ$1 Ϊ ʽַ
##========================================
function redFont()
{
    echo -e "\033[31m[ $1 ]\033[0m"
}

##=========================================
#  : ʾǷҪ
#  Σޡ
#  ˵Ҫ¹̼ʱļ ${NEED_UPDATE_FLAG}
##========================================
function updateTips()
{
     if [ -f ${NEED_UPDATE_FLAG} ] 
     then
        echo "=======================Attention==========================="
        echo "=============                            ================"
        echo -e "=============       \033[36mNeed to Update \033[0m      ================"        
        echo "=============                            ================"
        echo "========================================================="
     else
        
        echo "=======================Attention==========================="
        echo "=============                            ================"
        echo -e "=============       \033[36mDont Need to Update \033[0m ================"        
        echo "=============                            ================"
        echo "========================================================="
     fi
}



##=========================================
#  : ߵİ汾Ϣ
#  Σ
##========================================
function showVer()
{
   echo -e "StorScripts version : `cat ${STOR_VERSION}`"
   
}

##=========================================
#  : ¹̼ȼǰ״̬
#  : $1 currsegment ; $2 totalsegment
#        $3 progressinfo
##========================================
function updateProgress()
{
    local currsegment=$1
    local totalsegment=$2
    local progressinfo=$3
    progress=`expr $currsegment \* 90 / $totalsegment`
    echo "{\"detail\": \"${progressinfo}\", \"progress\": ${progress}}" >$UPDATE_PROCESS_LOG
    # echo Progress:$progress >$UPDATE_PROCESS_LOG
    # echo Info:$progressinfo >>$UPDATE_PROCESS_LOG
}

##=========================================
#  : дԹнϢ
#  : $1 model ; $2 id 
#        $3 fwtype ; $4 result 
#        $5 currVer ; $6 targetVer 
#        $7 updatetime
##========================================
function updateResult()
{
    local model=$1
    local id=$2
    local fwtype=$3
    local result=$4
    local currVer=$5
    local targetVer=$6
    local updatetime=$7
    if [ $result = "success" ];then
        detail=""
    else
        if [ $fwtype = "pxe" ];then
            detail="$fwtype enable failed"
        else
            detail="$fwtype update failed"
        fi
    fi
    if [ $# = 8 ];then
        detail=$8
    fi
    echo $model,$id,$fwtype,$result,$currVer,$targetVer,$updatetime,$detail >>$UPDATE_RESULT_LOG
}



##=========================================
#  :tool·߿·뵽ػ
#  Σtool·ӲȡΪ6,
#        ļĵ
##========================================
function setEnvVar()
{
    local toolPath=$6   
    local fullToolPath=$SCRIPT_PATH"/"$toolPath
    
    if [ -d "${fullToolPath}" ]
    then
    
        if [ -z $LD_LIBRARY_PATH ]
        then
            export LD_LIBRARY_PATH=${fullToolPath}
        else
            export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:${fullToolPath}
        fi

        chmod 777 -R ${fullToolPath}
     else
        redFont "${fullToolPath} dont exist,please check config file"
     fi
}

##==========================================#
# ܣ windowsе\r\nȥ
#˵
#  $1  Ϊתļ
#  
##==========================================#
function dosToUnix()
{
    local fileName=$1
    
    OLD_IFS="$IFS"
    IFS=$'\r\n'
    
    cat $fileName | while read LINE
    do
        echo $LINE>>$1.unix        
    done
    IFS="$OLD_IFS" 
    
    mv $1.unix $1
}


##==========================================#
#   ļʹļÿеֵΪûص
#˵
#  $1  Ϊļ
#  $2  ΪļִеĻص
#  $3  ΪļЧеĸ
#  $4  ΪõflagǷͨlistʽã򲻸½
# ע callbackǴݽ飬ڻ
#  https://www.jb51.net/article/110463.htm
#  https://blog.csdn.net/brouse8079/article/details/6417836
##==========================================#
function parseConf()
{
    local fileName=$1
    local cs=$2
    local csParaNum=$3

    dosToUnix $1
    totalline=`cat $fileName |grep -v -E "^\s*$|^\s*#"|wc -l`
    totalsegment=`expr $totalline \* 2 `
    currsegment=0
    #"^\s*$  ƥУжΪ пո tab  س
    # ^\s*#  ƥע
    cat $fileName |grep -v -E "^\s*$|^\s*#"| while read LINE
    do
       line=$LINE
       OLD_IFS="$IFS"
       #ļfw.confΪfw.csv,˴'|'ָΪ','
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS" 
       
       
       if [ ${#configInfo[@]} -ge $csParaNum ]
       
       then                      
           device=`echo ${configInfo[0]}`
           vendor=`echo ${configInfo[1]}`
           model=`echo ${configInfo[2]}`
           fwtype=`echo ${configInfo[3]}`
           fwver=`echo ${configInfo[4]}`
           fwtools=`echo ${configInfo[5]}`
           fwfiles=`echo ${configInfo[6]}`
           let currsegment=$currsegment+1
           progressinfo=`echo ${model} ${fwtype} updating`
           if [ $# != 4 ];then
               updateProgress $currsegment $totalsegment "$progressinfo"
           fi
           $cs "$device" "$vendor" "$model" "$fwtype" "$fwver" "$fwtools" "$fwfiles" "${@:4}"
           let currsegment=$currsegment+1
           progressinfo=`echo ${model} ${fwtype} update finished`
           if [ $# != 4 ];then
               updateProgress $currsegment $totalsegment "$progressinfo"
           fi
       else
           redFont "please check config file only have" ${#configInfo[@]} "char |,need " $csParaNum
           echo $LINE 
       fi 
    done

}
