#!/bin/bash

#升级fw工具
MELLANOX_UPDATE_FW_TOOL_NAME="mlxconfig"
MELLANOX_COMMAND_DIR="tools/mellanox/command"


##==========================================#
# 功能： 将windows中的\r\n换行去掉
#入参说明：
#  $1  为待转换的配置文件
##==========================================#
function dosToUnix()
{
    local fileName=$1
    OLD_IFS="$IFS"
    IFS=$'\r\n'
    cat $fileName | while read LINE
    do
        echo $LINE>>$1.unix
    done
    IFS="$OLD_IFS"
    mv $1.unix $1
}

##===================================#
# 功能： 获取mellanox卡的数量
# 入参：$1 卡类型
#       $2 mellanox卡信息文件
# 输出：mellanox_num_file
##===================================#
function get_mellanox_num()
{
    local ctrlModel=$1
    local mellanox_info_file=$2
    local total_num=0
    while read myline
    do
        local cardtype=$(echo $myline|awk '{print$2}')
        if [ "x${cardtype}" = "x${ctrlModel}" ];then
            let total_num=total_num+1
        fi
    done <${mellanox_info_file}
    echo "$total_num" > "mellanox_num_file"
}
##===================================#
# 功能： MLXX信息查询
# 入参：配置文件 各列
#    $1  model    : 网卡类型;
#    $2  filename ：发布的最新固件文件;
#    $3  newVer   : 建议或待升级的固件版本号;
#    $4  fwType   ：固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息
##===================================#
function listMlxxDriveDetails()
{
    local ctrlModel=$1
    local infoFile=$2
    local newVer=$3
    local fwType=$4
    if [ ${fwType} = "default" ];then
        printf "%-10s %-10s %-12s %-10s %-11s %-8s %-3s\n"   Device  Verdor MlxDev Model FwType FwVer >>mlxx.list
    fi
    OLD_IFS="$IFS"
    IFS=$'\n'
    while read myline
    do
        local mellanox_type="unknown"
        mellanox_type=$(echo $myline |awk '{print$2}')
        if [ "x${mellanox_type}" = "x${ctrlModel}" ];then
            mlxdev=$(echo $myline | awk '{print $1}')
            if [ ${fwType} = "default" ];then
                local CtrlVer=$(mlxfwmanager -d /dev/mst/$mlxdev |grep 'FW' |grep -v 'Running' |awk '{print $2}' | sed -e 's/^[ \t]*//g')
            fi
            if [ ${CtrlVer} = ${newVer} ];then
                printf "\e[37m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "nic" "mellanox" ${mlxdev} ${ctrlModel} ${fwType} "${CtrlVer}"  >>mlxx.list
            else
                echo "need update" >>${NEED_UPDATE_FLAG}
                printf "\e[31m%-10s %-10s %-12s %-10s %-11s %-8s %-3s \e[0m\n" "nic" "mellanox" ${mlxdev} ${ctrlModel} ${fwType} "${CtrlVer}"  >>mlxx.list
            fi
        else
            continue
        fi
    done < $infoFile
    IFS="$OLD_IFS"
    echo -e ""     >>mlxx.list
}

##===================================#
# 功能： MLXX固件信息查询
# 入参：配置文件 各列
#     $1  model ：控制器类型;
#     $2  newVer: 建议或待升级的固件版本号;
#     $3  fwType: 固件类型
# 输出：子卡总数，显示子卡详细信息： 设备类型，厂商，型号，固件类型，序列号，当前固件版本号，位置等信息。
##===================================#
function listMlxxDrive()
{
    local ctrlModel=$1
    local newVer=$2
    local fwType=$3

    declare -A map
    while read LINE
    do
       line=$LINE
       OLD_IFS="$IFS"
       #由于配置文件fw.conf改为了fw.csv,此处'|'分隔符变更为','
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS"
    map["${configInfo[1]}"]="${configInfo[0]}"
    done < ${MELLANOX_CARD_MAP}

    if [ ! -f "MlxxInfo.tmp" ]
    then
        echo "scaning the mellanox nic card in server......."
        #Add Useful Command
        chmod -R 777 ${SCRIPT_PATH}"/"${MELLANOX_COMMAND_DIR}
        for binFile in ${SCRIPT_PATH}"/"${MELLANOX_COMMAND_DIR}"/"bin"/"*
        do
            if [ ! -f /usr/bin/`basename ${binFile}` ];then
                cp ${binFile}  /usr/bin/
            fi
        done

        for sbinFile in ${SCRIPT_PATH}"/"${MELLANOX_COMMAND_DIR}"/"sbin"/"*
        do
            if [ ! -f /usr/sbin/`basename ${sbinFile}` ];then
                cp ${sbinFile}  /usr/sbin/
            fi
        done

        #Load Mlx Drivers
        depmod -a
        modprobe -v mlx5_core     >driverInfo.tmp 2>&1
        modprobe -v mst_pci      >>driverInfo.tmp 2>&1
        modprobe -v mst_pciconf  >>driverInfo.tmp 2>&1
        #Start mst
        mst start                >>driverInfo.tmp 2>&1

        #Check Drivers Load Result
        driverResultCheck=$(cat driverInfo.tmp |grep 'Failure'|wc -l )
        if [ ${driverResultCheck} -ne 0 ];then
            printf "\e[37mLack mellanox service tool \e[0m\n"
        fi

        for mlxdev in `ls /dev/mst/ |grep -v '\.'`
        do
            mlxPsid=$(mlxfwmanager -d /dev/mst/$mlxdev |grep 'PSID' |awk -F ':' '{print $2}'| sed -e 's/^[ \t]*//g')
            echo ${mlxdev} ${map["${mlxPsid}"]} >>MlxxInfo.tmp
        done

        if [ ! -f "MlxxInfo.tmp" ];then
            echo "No Mellanox card" >MlxxInfo.tmp
        fi
    fi

    get_mellanox_num "${ctrlModel}" "MlxxInfo.tmp"

    local TotalNum=`cat "mellanox_num_file"`
    rm -rf "mellanox_num_file"

    if [ $fwType = "default" ];then
        echo -e "====================mellanox nic card model(${ctrlModel}) info===================== " >>mlxx.list
        printf "%-10s: %-8s\n"   TotalNum  ${TotalNum}    >>mlxx.list
    fi
    if [ ${TotalNum} -ne 0 ]
    then
        listMlxxDriveDetails "${ctrlModel}" "MlxxInfo.tmp" "${newVer}" "$fwType"
    fi
}

##===================================#
# 功能： MELLANOX 网卡的固件升级结果检查
# 入参:
#       $1 : 升级结果文件
#       $2 : 固件类型
#       $3 : 待升级mellanox nic卡个数
##===================================#
function mlxxUpdateCheck()
{
    local mlxxresult=$1
    local fwType=$2
    local mellanoxNum=$3
    local ctrlModel=$4
    updateNum=$(cat $mlxxresult | wc -l)
    if [ $updateNum -eq 0 ];then
        return 0
    fi
    defaultFailed=$(cat $mlxxresult | grep ${ctrlModel} | grep "default update failed" | wc -l)
    defaultSucced=$(cat $mlxxresult | grep ${ctrlModel} | grep "default update OK" | wc -l)
    pxeFailed=$(cat $mlxxresult | grep ${ctrlModel} | grep "pxe enable failed" | wc -l)
    pxeSucess=$(cat $mlxxresult | grep ${ctrlModel} | grep "pxe enable OK" | wc -l)
    if [ $fwType = "default" ];then
        if [ $defaultFailed -eq 0 ] && [ $pxeFailed -eq 0 ];then
            greenFont "total mellanox card($ctrlModel) num:$mellanoxNum,fw succeed num:$defaultSucced,pxe enabled succeed num:$pxeSucess,fw failed num:$defaultFailed,pxe enabled failed num:$pxeFailed" | tee -a mlxx.result
        else
            redFont "total mellanox card($ctrlModel) num:$mellanoxNum,fw succeed num:$defaultSucced,pxe enabled succeed num:$pxeSucess,fw failed num:$defaultFailed,pxe enabled failed num:$pxeFailed,please Check!" | tee -a mlxx.result
            redFont "suggest to download suitable driver files and try to update once more!" | tee -a mlxx.result
            while read myline
            do
                defaultinfo=$(echo $myline | grep default | wc -l)
                if [ defaultinfo != 0 ];then
                   redFont "$myline" | tee -a mlxx.result
                fi
            done <$mlxxresult
        fi
    fi
}

##===================================#
# 功能： MELLANOX 网卡的固件升级
# 入参:
#       $1 : Nic model:网卡芯片类型
#       $2 : fw_file：待升级固件
#       $3 : newVersion：待升级固件版本信息
#       $4 : fwType：待升级固件类型
##===================================#
function updateMlxxFW()
{
    local ctrlModel=$1
    local fwFile=$2
    local newVersion=$3
    local fwType=$4

    declare -A map
    while read LINE
    do
       line=$LINE
       OLD_IFS="$IFS"
       #由于配置文件fw.conf改为了fw.csv,此处'|'分隔符变更为','
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS"
       map["${configInfo[1]}"]="${configInfo[0]}"
    done < ${MELLANOX_CARD_MAP}

    if [ ! -f "updateMlxxFW.tmp" ]
    then
        echo "scaning the mellanox nic card for update in server......." | tee -a ${UPDATE_LOG}
        #Add Useful Command
        chmod -R 777 ${SCRIPT_PATH}"/"${MELLANOX_COMMAND_DIR}
        for binFile in ${SCRIPT_PATH}"/"${MELLANOX_COMMAND_DIR}"/"bin"/"*
        do
            if [ ! -f /usr/bin/`basename ${binFile}` ];then
                cp ${binFile}  /usr/bin/
            fi
        done

        for sbinFile in ${SCRIPT_PATH}"/"${MELLANOX_COMMAND_DIR}"/"sbin"/"*
        do
            if [ ! -f /usr/sbin/`basename ${sbinFile}` ];then
                cp ${sbinFile}  /usr/sbin/
            fi
        done

        #Load Mlx Drivers
        depmod -a
        modprobe -v mlx5_core     >driverInfo.tmp 2>&1
        modprobe -v mst_pci      >>driverInfo.tmp 2>&1
        modprobe -v mst_pciconf  >>driverInfo.tmp 2>&1
        #Start mst
        mst start                >>driverInfo.tmp 2>&1

        #Check Drivers Load Result
        driverResultCheck=$(cat driverInfo.tmp |grep 'Failure'|wc -l )
        if [ ${driverResultCheck} -ne 0 ];then
            greenFont 'Lack mellanox service tool' |tee -a mlxx.result
        fi

        for mlxdev in `ls /dev/mst/ |grep -v '\.'`
        do
            mlxPsid=$(mlxfwmanager -d /dev/mst/$mlxdev |grep 'PSID' |awk -F ':' '{print $2}'| sed -e 's/^[ \t]*//g')
            echo ${mlxdev} ${map["${mlxPsid}"]} >>updateMlxxFW.tmp
        done

        if [ ! -f "updateMlxxFW.tmp" ];then
            echo "No Mellanox card" >updateMlxxFW.tmp
        fi
    fi

    get_mellanox_num "${ctrlModel}" "updateMlxxFW.tmp"
    local MellanoxContrlNum=$(cat "mellanox_num_file")
    rm -rf "mellanox_num_file"

    if [ ${MellanoxContrlNum} -eq 0 ]
    then
        echo -e "Total mellanox nic card(${ctrlModel}) num: 0,success num : 0" |tee -a mlxx.result
        greenFont "no mellanox nic card (${ctrlModel}) in this server,no need to update" |tee -a mlxx.result
        updateResult $ctrlModel "--" "default" "success" "--" "--" "0" "no card"
        return 0
    fi

    while read myline
    do
        local mellanox_type="unkown"
        mellanox_type=$(echo $myline |awk '{print$2}')
        if [ "x${mellanox_type}" = "x${ctrlModel}" ];then
            starttime=`date +'%Y-%m-%d %H:%M:%S'`
            start_seconds=$(date --date="$starttime" +%s)
            mlxdev=$(echo $myline | awk '{print $1}')
            if [ ${fwType} = "default" ];then
                local CtrlVer=$(mlxfwmanager -d /dev/mst/$mlxdev |grep 'FW' |grep -v 'Running' |awk '{print $2}' | sed -e 's/^[ \t]*//g')
            else
                redFont "mellanox nic card(${ctrlModel}) $mlxdev fwtype is error " | tee -a mlxx.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $mlxdev $fwType "failed" "--" $newVersion $updatetime
                continue
            fi

            if [ ${CtrlVer} = ${newVersion} ];then 
                greenFont "mellanox nic card(${ctrlModel}) $mlxdev $fwType is new version(${newVersion}) in this server,no need to update " |tee -a mlxx.result
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                updateResult $ctrlModel $mlxdev $fwType "success" $CtrlVer $newVersion $updatetime
            elif [ ${fwType} = "default" ];then
                #Update Firmware
                case "${ctrlModel}" in
                "MCX623102AS-ADAT"|"MCX623105AN-VDAT")
                    flint -d /dev/mst/$mlxdev -i $fwFile -y burn
                    ;;
                *)
                    flint -d /dev/mst/$mlxdev -i $fwFile -ocr -y burn
                    ;;
                esac
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                local CtrlVerNew=$(mlxfwmanager -d /dev/mst/$mlxdev |grep 'FW' |grep -v 'Running' |awk '{print $2}' | sed -e 's/^[ \t]*//g')
                if [ ${CtrlVerNew} = ${newVersion} ];then
                    echo "mellanox nic card($ctrlModel) $mlxdev $fwType update OK" >>mlxxresult.tmp
                    updateResult $ctrlModel $mlxdev $fwType "success" $CtrlVer $newVersion $updatetime
                else
                    echo "mellanox nic card($ctrlModel) $mlxdev $fwType update failed,please Check!" >>mlxxresult.tmp
                    updateResult $ctrlModel $mlxdev $fwType "failed" $CtrlVer $newVersion $updatetime
                fi
            fi
            pxeEnableParaNum=$($MELLANOX_UPDATE_FW_TOOL -d /dev/mst/$mlxdev q |grep EXP_ROM_UEFI_x86_ENABLE | wc -l)
            if [ ${pxeEnableParaNum} -ne 0 ];then
                #Enable
                starttime=`date +'%Y-%m-%d %H:%M:%S'`
                start_seconds=$(date --date="$starttime" +%s)
                $MELLANOX_UPDATE_FW_TOOL -d /dev/mst/$mlxdev -y set EXP_ROM_UEFI_x86_ENABLE=1
                endtime=`date +'%Y-%m-%d %H:%M:%S'`
                end_seconds=$(date --date="$endtime" +%s)
                updatetime=$((end_seconds-start_seconds))
                #Check
                enablestatus=`$MELLANOX_UPDATE_FW_TOOL -d /dev/mst/$mlxdev q |grep EXP_ROM_UEFI_x86_ENABLE |grep True |wc -l`
                if [ 1 -eq $enablestatus ];then
                    echo "mellanox nic card($ctrlModel) $mlxdev pxe enable OK" >>mlxxresult.tmp
                    updateResult $ctrlModel $mlxdev "pxe" "success" $CtrlVer $newVersion $updatetime
                else
                    echo "mellanox nic card($ctrlModel) $mlxdev pxe enable failed,please Check!" >>mlxxresult.tmp
                    updateResult $ctrlModel $mlxdev "pxe" "failed" $CtrlVer $newVersion $updatetime
                fi
            fi
        else
            continue
        fi
    done < updateMlxxFW.tmp
    if [ -f "mlxxresult.tmp" ];then
        mlxxUpdateCheck "mlxxresult.tmp" "$fwType" "$MellanoxContrlNum" "$ctrlModel"
        rm -rf "mlxxresult.tmp"
    fi

}

##===================================#
# 功能：MLXX的固件升级入口
# 入参：配置文件 各列
#     $1  device ; $2 vender ;$3 Model 
#     $4  FwType ; $5 FwVer  ;$6 固件升级的工具路径
#     $7  固件的版本文件
##===================================#
function mlxxMain()
{

    local deviceType=$1
    local vendorType=$2
    local contrlModel=$3
    local fwType=$4
    local fwVer=$5
    local fwToolsDir=$6
    local fwFiles=$7

    local fullPathFw="${FIRMWARE_PATH}/${fwFiles}"  

    MELLANOX_UPDATE_FW_TOOL=${SCRIPT_PATH}"/"${fwToolsDir}"/"${MELLANOX_UPDATE_FW_TOOL_NAME}

    if [ ! -f "${MELLANOX_UPDATE_FW_TOOL}" -o ! -f "${fullPathFw}" ]
    then
        redFont " ${MELLANOX_UPDATE_FW_TOOL} or ${fullPathFw} dont exist"
        return 0
    fi
    
    dosToUnix ${MELLANOX_CARD_MAP}
    #非配置文件中的参数处理    
    if [ $# -gt ${CFG_FILE_COLUMN_NUM} ]
    then 
    
       local paraStartPos
       let paraStartPos=${CFG_FILE_COLUMN_NUM}+1
       for moreArgs in ${@:${paraStartPos}}
       do
          case "${moreArgs}" in 
             "list")
              listMlxxDrive "${contrlModel}" "${fwVer}" "${fwType}"
              ;;
              *) 
              echo "no implement function :${moreArgs}"
              ;;
          esac 
       done
   
       return 0
    fi    
    
    declare -A map
    while read LINE
    do
       line=$LINE
       OLD_IFS="$IFS"
       #由于配置文件fw.conf改为了fw.csv,此处'|'分隔符变更为','
       IFS=","
       configInfo=($LINE)
       IFS="$OLD_IFS"   
       map["${configInfo[1]}"]="${configInfo[0]}"     
    done < ${MELLANOX_CARD_MAP}
    #固件升级
    declare -i num=1
    for val in ${map[@]};do
        if [ $val = $contrlModel ];then
            break
        else
            num=$[ $num + 1 ]
        fi
    done
    if [ $num -le ${#map[@]} ];then
        if [ $deviceType = "nic" -a $vendorType = "MELLANOX" ];then
            updateMlxxFW "${contrlModel}" "${fullPathFw}" "${fwVer}" "${fwType}"
        else
            echo "don't support $deviceType or $vendorType"
        fi
    else
        echo "don't support mellanox nic card model :${contrlModel}" 
    fi

}

mlxxMain $@